/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.service.UserFields;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.teamcity.persistence.CommandExecutionInfo;
import jetbrains.charisma.workflow.exceptions.WorkflowException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.notifications.NotificationProvider;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.VcsChangeWrapper;
import jetbrains.youtrack.integration.vcs.VcsConstraintErrorMessageUtil;
import jetbrains.youtrack.integration.vcs.VcsMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcsChangeImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "VcsChange";
    public static final String REVISION = "${revision}";
    private static final String SPACES = "\t\\f ";
    private static String SPACES_IN_BRACES = "[\t\\f ]";
    private static final String SEPARATOR_REGEX = "[.:\"()?\t\\f ]";
    private static final String COMMAND_PREFIX_REGEX = "[#\\^][a-zA-Z0-9_]+\\-\\d+";
    private static final String ISSUE_COMMAND_REGEX = ".*?([#\\^][a-zA-Z0-9_]+\\-\\d+(" + SPACES_IN_BRACES + "*[,;]" + SPACES_IN_BRACES + "*" + "[#\\^][a-zA-Z0-9_]+\\-\\d+" + ")*)(" + "[.:\"()?\t\\f ]" + SPACES_IN_BRACES + "*([\\S" + "\t\\f " + "]+?))?$|(.+?$)";
    public static final Pattern COMMAND_PATTERN = Pattern.compile(ISSUE_COMMAND_REGEX, 8);
    private static final Pattern COMMAND_PREFIX_PATTERN = Pattern.compile("[#\\^]([a-zA-Z0-9_]+\\-\\d+)");
    public static final byte DEFAULT = 0;
    public static final byte MANUALLY_ATTACHED = 1;
    public static final byte DETACHED = 2;
    public static final byte LEGACY = 3;
    protected static Log log = LogFactory.getLog(VcsChangeImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity _constructor(CommonChangeDTO change, String _entityType_) {
        final Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"issue", (Entity)change.issue);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"processor", (Entity)QueryOperations.getFirst(change.processors));
        Sequence.fromIterable(change.processors).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                DirectedAssociationSemantics.createToMany((Entity)entity, (String)"processors", (Entity)__addallit__);
            }
        });
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"userName", (Comparable)((Object)change.userName), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"date", (Comparable)change.date);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"comment", (String)change.comment);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"version", (Comparable)((Object)change.version), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"branch", (Comparable)((Object)change.branch), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"files", (Comparable)Integer.valueOf(change.files), Integer.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"user", (Entity)change.user);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"noUserReason", (Entity)change.noUserReason);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"noHubUserReason", (Entity)change.noHubUserReason);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"state", (Comparable)Byte.valueOf(change.state), Byte.class);
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance(new StatisticsFeatureDescription("vcs", entity.getType() + ".changeCreated"));
        if (!EntityOperations.equals((Entity)change.user, null)) {
            try {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)change.user);
                ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForUser(new StatisticsFeatureDescription("vcs", entity.getType() + ".userResolved"));
            }
            finally {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
            }
        }
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("user".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return VcsConstraintErrorMessageUtil.createReportAboutVcsChanges(linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        Entity p;
        super.executeBeforeFlushTrigger(entity);
        if (AssociationSemantics.getToManySize((Entity)entity, (String)"processors") == 0L) {
            EntityOperations.remove((Entity)entity);
        } else if ((EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"processor"), null) || EntityOperations.isRemoved((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"processor"))) && !EntityOperations.equals((Entity)(p = QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"processors")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        }))), null)) {
            DirectedAssociationSemantics.setToOne((Entity)entity, (String)"processor", (Entity)p);
        }
    }

    public void executeCommands(Entity user2, Entity entity) {
        if (VcsChangeImpl.isEmpty_xviodn_a0a0e(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"comment"))) {
            return;
        }
        Matcher matcher = COMMAND_PATTERN.matcher(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"comment"));
        IListSequence execInfos = ListSequence.fromList(new ArrayList());
        boolean waitForComment = false;
        IListSequence issueCommentParts = ListSequence.fromList(new ArrayList());
        IListSequence commandsWithComments = ListSequence.fromList(new ArrayList());
        while (matcher.find()) {
            String issueIds = matcher.group(1);
            String commentPart = matcher.group(5);
            if (issueIds != null) {
                waitForComment = false;
                if (ListSequence.fromList((List)issueCommentParts).isNotEmpty()) {
                    ((Tuples._5)ListSequence.fromList((List)commandsWithComments).last())._4((Object)IterableUtils.join((Iterable)ListSequence.fromList((List)issueCommentParts), (String)"\n"));
                    ListSequence.fromList((List)issueCommentParts).clear();
                }
                if (!((VcsChangeImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsChange")).containsTargetId(issueIds, entity)) continue;
                ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance(new StatisticsFeatureDescription("vcs", entity.getType() + ".hasCommand"));
                int commandStart = matcher.start(4);
                int commandEnd = matcher.end(4);
                if (EntityOperations.equals((Entity)user2, null)) {
                    CommandExecutionInfo execInfo = new CommandExecutionInfo(commandStart, commandEnd);
                    execInfo.setErrorText(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityChange.Could_not_resolve_Youtrack_user", new Object[0]));
                    ListSequence.fromList((List)execInfos).addElement((Object)execInfo);
                    continue;
                }
                waitForComment = true;
                ListSequence.fromList((List)commandsWithComments).addElement((Object)MultiTuple.from((Object)this.parseCommandString(matcher.group(4), entity), (Object)commandStart, (Object)commandEnd, (Object)user2, (Object)null));
                continue;
            }
            if (!waitForComment) continue;
            ListSequence.fromList((List)issueCommentParts).addElement((Object)commentPart);
        }
        if (ListSequence.fromList((List)issueCommentParts).isNotEmpty()) {
            ((Tuples._5)ListSequence.fromList((List)commandsWithComments).last())._4((Object)IterableUtils.join((Iterable)ListSequence.fromList((List)issueCommentParts), (String)"\n"));
        }
        for (Tuples._5 cc : ListSequence.fromList((List)commandsWithComments)) {
            if (!VcsChangeImpl.isNotEmpty_xviodn_a0a0i0e(VcsChangeImpl.trim_xviodn_a0a0a8a4(((ICommandList)cc._0()).getText()))) continue;
            ListSequence.fromList((List)execInfos).addSequence(Sequence.fromIterable(this.executeCommandsAndStoreInfos((ICommandList)cc._0(), (Integer)cc._1(), (Integer)cc._2(), (Entity)cc._3(), (String)cc._4(), entity)));
        }
        if (ListSequence.fromList((List)execInfos).isNotEmpty()) {
            PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"commandExecutionInfos", (String)CommandExecutionInfo.marshal((Iterable<CommandExecutionInfo>)execInfos));
        }
    }

    private boolean containsTargetId(String ids, Entity entity) {
        Matcher matcher = COMMAND_PREFIX_PATTERN.matcher(ids);
        while (matcher.find()) {
            if (!((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).getId(AssociationSemantics.getToOne((Entity)entity, (String)"issue")).equalsIgnoreCase(matcher.group(1))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommandList parseCommandString(String command, Entity entity) {
        Context context = new Context();
        context.setSelectedIssues(QueryOperations.singleton((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue")));
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)AssociationSemantics.getToOne((Entity)entity, (String)"user"));
            ICommandList iCommandList = ((CommandService)ServiceLocator.getBean((String)"commandService")).parse(command, (IContext)context);
            return iCommandList;
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<CommandExecutionInfo> executeCommandsAndStoreInfos(final ICommandList commandList, final int commandStringStart, int commandStringEnd, final Entity user2, final String issueComment, final Entity entity) {
        Iterable iterable;
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user2);
            if (commandList.hasErrors()) {
                Iterable<CommandExecutionInfo> iterable2 = this.processCommandList(commandList, commandStringStart, entity);
                return iterable2;
            }
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
        final Entity hostIssue = AssociationSemantics.getToOne((Entity)entity, (String)"issue");
        final boolean addComments = (Boolean)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"processor"), (String)"addComments", Boolean.class, null);
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user2);
            iterable = (Iterable)_Txn.evalNew((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Iterable<CommandExecutionInfo>>(){

                public Iterable<CommandExecutionInfo> invoke() {
                    commandList.execute(false);
                    Iterable executionInfos = VcsChangeImpl.this.processCommandList(commandList, commandStringStart, entity);
                    if (!Sequence.fromIterable((Iterable)executionInfos).any((_FunctionTypes._return_P1_E0)new IWhereFilter<CommandExecutionInfo>(){

                        public boolean accept(CommandExecutionInfo it) {
                            return it.getIsError();
                        }
                    }) && issueComment != null && issueComment.length() > 0 && addComments) {
                        Entity comment = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)hostIssue, (String)"Issue")).addComment(issueComment, hostIssue);
                        PrimitiveAssociationSemantics.set((Entity)comment, (String)"usesMarkdown", (Comparable)Boolean.valueOf(((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(user2).isUseMarkdown()), Boolean.class);
                    }
                    return executionInfos;
                }
            });
        }
        catch (Throwable throwable) {
            try {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
                throw throwable;
            }
            catch (Exception e) {
                CommandExecutionInfo execInfo = new CommandExecutionInfo(commandStringStart, commandStringEnd);
                execInfo.setErrorText(e instanceof WorkflowException ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("VcsChange.Workflow_error_{0}", new Object[]{e.getMessage()}) : ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityChange.Command_execution_failed_{error_message}", new Object[]{e.getMessage()}));
                return Sequence.singleton((Object)execInfo);
            }
        }
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        return iterable;
    }

    private Iterable<CommandExecutionInfo> processCommandList(ICommandList commandList, final int commandStringStart, Entity entity) {
        return Sequence.fromIterable((Iterable)commandList.getCommands()).translate((_FunctionTypes._return_P1_E0)new ITranslator2<ICommand, ICell>(){

            public Iterable<ICell> translate(ICommand command) {
                return command.getCells();
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICell>(){

            public boolean accept(ICell cell) {
                return cell.getType() != 4;
            }
        }).select((_FunctionTypes._return_P1_E0)new ISelector<ICell, CommandExecutionInfo>(){

            public CommandExecutionInfo select(ICell cell) {
                CommandExecutionInfo execInfo = new CommandExecutionInfo(commandStringStart + cell.getStart(), commandStringStart + cell.getEnd());
                if (cell.isError()) {
                    execInfo.setErrorText(cell.getText());
                }
                return execInfo;
            }
        }).toListSequence();
    }

    public void notifyOnError(Entity entity) {
        if (Sequence.fromIterable(this.getCommandExecutionInfos(entity)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<CommandExecutionInfo>(){

            public boolean accept(CommandExecutionInfo it) {
                return it.getIsError();
            }
        }).isEmpty()) {
            return;
        }
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"noUserReason"), null)) {
            Entity user2;
            Entity issue = AssociationSemantics.getToOne((Entity)entity, (String)"issue");
            Entity assignee = QueryOperations.getFirst((Iterable)((UserFields)ServiceLocator.getBean((String)"userFields")).getIssueAssignees(issue));
            Entity entity2 = user2 = !EntityOperations.equals((Entity)assignee, null) ? assignee : AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"project"), (String)"leader");
            if (EntityOperations.equals((Entity)user2, null)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Issue has neither assignee nor project leader");
                }
                return;
            }
            IMapSequence data = MapSequence.fromMap(new HashMap());
            MapSequence.fromMap((Map)data).put((Object)"to", (Object)user2);
            MapSequence.fromMap((Map)data).put((Object)"vcsChange", ((VcsChangeWrapper)ServiceLocator.getBean((String)"vcsChangeWrapper")).wrap(entity));
            VcsChangeImpl.notify("vcsBadUser", user2, issue, (Map<String, Object>)data);
        } else {
            IMapSequence data = MapSequence.fromMap(new HashMap());
            MapSequence.fromMap((Map)data).put((Object)"to", (Object)AssociationSemantics.getToOne((Entity)entity, (String)"user"));
            MapSequence.fromMap((Map)data).put((Object)"vcsChange", ((VcsChangeWrapper)ServiceLocator.getBean((String)"vcsChangeWrapper")).wrap(entity));
            VcsChangeImpl.notify("vcsBadCommand", AssociationSemantics.getToOne((Entity)entity, (String)"user"), AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (Map<String, Object>)data);
        }
    }

    public boolean hasCommands(Entity entity) {
        return VcsChangeImpl.isNotEmpty_xviodn_a0a0k(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"commandExecutionInfos"));
    }

    public Iterable<CommandExecutionInfo> getCommandExecutionInfos(Entity entity) {
        if (VcsChangeImpl.isEmpty_xviodn_a0a0l(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"commandExecutionInfos"))) {
            return Sequence.fromIterable(Collections.emptyList());
        }
        try {
            return CommandExecutionInfo.unmarshal(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"commandExecutionInfos"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public CommonChangeDTO toDto(Entity entity) {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"processor"), (String)"ChangesProcessor")).toDto(entity, AssociationSemantics.getToOne((Entity)entity, (String)"processor"));
    }

    public static Entity constructor(CommonChangeDTO change) {
        return ((VcsChangeImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(change, __ENTITY_TYPE__);
    }

    public static void notify(String caseId, Entity recipient, Entity issue, Map<String, Object> data) {
        if (VcsMethods.isCCCNotificationsEnabled(AssociationSemantics.getToOne((Entity)recipient, (String)"profile")).booleanValue()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Sending VCS command notification to user " + (String)PrimitiveAssociationSemantics.get((Entity)recipient, (String)"fullName", String.class, null)));
            }
            ((NotificationProvider)ServiceLocator.getBean((String)"notificationProvider")).notify(caseId, recipient, issue, data);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Will not send a VCS command notification to user '" + (String)PrimitiveAssociationSemantics.get((Entity)recipient, (String)"fullName", String.class, null) + "' since they've disabled the notifications in their profile"));
        }
    }

    public static boolean isEmpty_xviodn_a0a0e(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_xviodn_a0a0i0e(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim_xviodn_a0a0a8a4(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isNotEmpty_xviodn_a0a0k(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty_xviodn_a0a0l(String str) {
        return str == null || str.length() == 0;
    }
}

