/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.customfields.complex.user.UsersBundleImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.HubUuidResolver;
import jetbrains.youtrack.core.scheduling.SchedulingOptions;
import jetbrains.youtrack.customfields.ring.AssigneeFieldLocator;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcsServerImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "VcsServer";
    public static final int CHANGES_BULK_SIZE = 100;
    protected static Log log = LogFactory.getLog(VcsServerImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"enabled", (Comparable)Boolean.valueOf(true), Boolean.class);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"url", (Comparable)((Object)VcsServerImpl.trim_w1wqc_a2a1a2((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null))), String.class);
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors2, String version, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean isNextFetchAllowed(Entity entity) {
        return SchedulingOptions.isNextCronJobAllowed((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"lastFetchStart", null)), (int)SchedulingOptions.getMinIntervalBetweenCronJobsForHostedYouTrack());
    }

    public void process(Iterable<Entity> cps, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"lastFetchStart", (Comparable)Long.valueOf(System.currentTimeMillis()));
        DnqUtils.getCurrentTransientSession().flush();
        ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).doProcess(false, ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).getLegibleProcessors(cps, entity), entity);
    }

    public void processAsync(Iterable<Entity> cps, Entity entity) {
        if (!this.isEnabled(entity)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"This method should not have been invoked since the integration is disabled");
            }
            return;
        }
        ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).doProcess(true, ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).getLegibleProcessors(cps, entity), entity);
    }

    public Iterable<Entity> getLegibleProcessors(Iterable<Entity> cps, Entity entity) {
        if (cps == null) {
            cps = QueryOperations.query(null, (String)"ChangesProcessor", (NodeBase)new LinkEqual("server", entity));
        } else {
            TreeKeepingEntityIterable foreign = QueryOperations.query((Iterable)cps, (String)"ChangesProcessor", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("server", entity)));
            if (!QueryOperations.isEmpty((Iterable)foreign)) {
                throw new IllegalArgumentException("Some of the changes processors does not belong to this server: " + IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)foreign).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                    public String select(Entity it) {
                        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ChangesProcessor")).getLogPrefix(it);
                    }
                }), (String)","));
            }
        }
        return Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)cps, (String)"ChangesProcessor", (NodeBase)new And((NodeBase)new PropertyEqual("enabled", (Comparable)Boolean.TRUE), (NodeBase)new UnaryNot((NodeBase)new LinksEqualDecorator("project", (NodeBase)new PropertyEqual("archived", (Comparable)Boolean.TRUE), "Project"))))).toListSequence();
    }

    protected void doProcess(boolean async, Iterable<Entity> cps, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean shouldResetClient(Entity entity) {
        return false;
    }

    public boolean isEnabled(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null);
    }

    public Tuples._2<Entity, Entity> resolveUser(String email, Entity cp, Entity noUserError, Entity multiUsersError, Entity entity) {
        TreeKeepingEntityIterable users = QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("email", (Comparable)((Object)email)));
        Tuples._2<Entity, Entity> userResolution = ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).resolveUser((Iterable<Entity>)users, cp, noUserError, multiUsersError, entity);
        return MultiTuple.from((Object)userResolution._0(), (Object)DnqUtils.cast((Object)userResolution._1(), (String)"NoUserReason"));
    }

    private Tuples._2<Entity, Entity> resolveUser(Iterable<Entity> users, Entity cp, Entity noUserError, Entity multiUsersError, Entity entity) {
        if (QueryOperations.isEmpty(users)) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)noUserError);
        }
        if (!(QueryOperations.isEmpty((Iterable)QueryOperations.skip(users, (int)1)) || !QueryOperations.isEmpty(users = ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).findRelevantUsers(cp, users, entity)) && QueryOperations.isEmpty((Iterable)QueryOperations.skip(users, (int)1)))) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)multiUsersError);
        }
        return MultiTuple.from((Object)QueryOperations.getFirst(users), (Object)DnqUtils.cast(null, (String)"NoUserReason"));
    }

    public Tuples._2<Entity, Entity> resolveInHub(Entity cp, String vcsUserName, Entity entity) {
        List users;
        try {
            users = ((HubUuidResolver)ServiceLocator.getBean((String)"hubUuidResolver")).findUsersByVcsUsername(vcsUserName);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Error while looking up a vcs user [" + vcsUserName + "] in hub"), (Throwable)e);
            }
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.HUB_ERROR_FORCE_SYNC.get());
        }
        return ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).resolveUser(users, cp, NoUserReasonImpl.HUB_NULL_USER.get(), NoUserReasonImpl.HUB_MULTIPLE_USERS.get(), entity);
    }

    protected Iterable<Entity> findRelevantUsers(Entity cp, Iterable<Entity> users, Entity entity) {
        Entity assigneeBundle = ((AssigneeFieldLocator)ServiceLocator.getBean((String)"assigneeFieldLocator")).getAssigneeFieldBundle(AssociationSemantics.getToOne((Entity)cp, (String)"project"));
        if (!EntityOperations.equals((Entity)assigneeBundle, null)) {
            return QueryOperations.intersect(users, (Iterable)((UsersBundleImpl)DnqUtils.getPersistentClassInstance((Entity)assigneeBundle, (String)"UsersBundle")).getUsers(assigneeBundle));
        }
        return users;
    }

    public static Entity constructor() {
        return ((VcsServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static String trim_w1wqc_a2a1a2(String str) {
        return str == null ? null : str.trim();
    }
}

