/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.ui;

import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.teamcity.persistence.CommandExecutionInfo;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.ui.StringUtils;

public class ChangeFormater {
    private ChangeFormater() {
    }

    public static String formatCommentFor(CommonChangeDTO change) {
        return ChangeFormater.formatCommentFor(change.comment, change.commandExecutionInfos, ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)change.issue, (String)"Issue")).getId(change.issue));
    }

    public static String formatCommentFor(String comment, Iterable<CommandExecutionInfo> executionInfos, String issueId) {
        if (Sequence.fromIterable(executionInfos).count() == 0) {
            return ChangeFormater.addTitle(comment, issueId);
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (CommandExecutionInfo info : Sequence.fromIterable(executionInfos)) {
            sb.append(StringUtils.substring(comment, index, info.getStart()));
            ChangeFormater.formatCommandPart(sb, comment, info);
            index = info.getEnd();
        }
        sb.append(comment.substring(index));
        return sb.toString();
    }

    private static void formatCommandPart(StringBuilder sb, String comment, CommandExecutionInfo info) {
        String text = StringUtils.substring(comment, info.getStart(), info.getEnd());
        String trimmedText = text == null ? null : text.trim();
        int trimmedTextStart = text.indexOf(trimmedText);
        sb.append(StringUtils.substring(text, 0, trimmedTextStart));
        if (info.getIsError()) {
            if (trimmedText.length() == 0) {
                sb.append(" ");
            }
            ChangeFormater.appendTextWithHint(sb, true, trimmedText.length() > 0 ? trimmedText : "_", info.getErrorText());
        } else {
            sb.append("'''").append("+").append(text).append("+").append("'''");
        }
        sb.append(StringUtils.substring(text, trimmedTextStart + trimmedText.length()));
    }

    private static StringBuilder appendTextWithHint(StringBuilder sb, boolean isError, String text, String onHover) {
        sb.append("~~");
        if (isError) {
            sb.append("+{color:red}");
        }
        sb.append(text);
        if (isError) {
            sb.append("{color}+");
        }
        sb.append("|");
        sb.append(onHover);
        sb.append("~~");
        return sb;
    }

    public static String addHint(boolean isError, String text, String onHover) {
        return ChangeFormater.appendTextWithHint(new StringBuilder(), isError, text, onHover).toString();
    }

    private static String addTitle(String comment, String issueId) {
        if (comment == null || comment.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : comment.split("\n", -1)) {
            if (!first) {
                sb.append("\n");
            }
            first = false;
            if (s.length() <= 0) continue;
            ChangeFormater.appendTextWithHint(sb, false, s, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ChangeFormater.The_comment_does_not_contain_any_command_for_issue_{0}", new Object[]{issueId}));
        }
        return sb.toString();
    }
}

