/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.webapp.filters;

import com.intellij.hub.auth.OAuthException;
import com.intellij.hub.core.Error;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.user.XdApiKey;
import jetbrains.charisma.user.apiKey.ApiKeyImpl;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.provider.exception.UnauthorizedException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.filters.YouTrackCORSContainerResponseFilter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import webr.framework.controller.BaseApplication;

@Service(value="restLoginFilter")
@PreMatching
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/webapp/filters/RESTLoginRequestFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "()V", "filter", "", "req", "Ljavax/ws/rs/container/ContainerRequestContext;", "Companion", "youtrack-webapp"})
public final class RESTLoginRequestFilter
implements ContainerRequestFilter {
    @NotNull
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String API_KEY_HEADER = "X-YouTrack-ApiKey";
    private static final String API_KEY_PARAM = "apiKey";
    private static final Set<String> ALLOWED_TO_BANNED_LOCATIONS;
    private static final Set<String> ALLOWED_TO_BANNED_LOCATIONS_PREFIX;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void filter(@Nullable ContainerRequestContext req) {
        void allowAllOrigins;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (req != null && Intrinsics.areEqual((Object)"OPTIONS", (Object)req.getMethod()) ^ true) {
            void found;
            String apiKeyValue = RESTLoginRequestFilter.Companion.getApiKey(req);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            String authHeaderValue = req.getHeaderString(AUTHORIZATION_HEADER);
            if (apiKeyValue != null) {
                TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(req, apiKeyValue, (Ref.ObjectRef)found, (Ref.BooleanRef)allowAllOrigins){
                    final /* synthetic */ ContainerRequestContext $req$inlined;
                    final /* synthetic */ String $apiKeyValue$inlined;
                    final /* synthetic */ Ref.ObjectRef $found$inlined;
                    final /* synthetic */ Ref.BooleanRef $allowAllOrigins$inlined;
                    {
                        this.$req$inlined = containerRequestContext;
                        this.$apiKeyValue$inlined = string;
                        this.$found$inlined = objectRef;
                        this.$allowAllOrigins$inlined = booleanRef;
                        super(1);
                    }

                    public final Unit invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        UriInfo uriInfo = this.$req$inlined.getUriInfo();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                        String path = uriInfo.getPath();
                        CharSequence charSequence = path;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.startsWith((String)path, (String)"vcshooksreceiver", (boolean)true)) {
                            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("YouTrackCorsContainerResponseFilter.An_API_key_can_only_be_used_for_VCS_hooks", new Object[0]));
                        }
                        Entity entity = ApiKeyImpl.find((String)this.$apiKeyValue$inlined);
                        if (entity == null || (entity = (XdApiKey)XdExtensionsKt.toXd((Entity)entity)) == null) {
                            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("RESTLoginRequestFilter.Unknown_api_key", new Object[0]));
                        }
                        Entity apiKey = entity;
                        this.$found$inlined.element = apiKey.getOwner();
                        BaseApplication.setSessionField((String)"SessionOrigin", (Object)"API key");
                        this.$allowAllOrigins$inlined.element = true;
                        return Unit.INSTANCE;
                    }
                }), (int)7, null);
            } else {
                try {
                    Entity entity = jetbrains.charisma.persistent.BeansKt.getHubUuidResolver().resolveUserByAuthHeader(authHeaderValue);
                    if (entity != null) {
                        Entity $i$f$transactional;
                        Entity it = $i$f$transactional = entity;
                        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(it, (Ref.ObjectRef)found, (Ref.BooleanRef)allowAllOrigins){
                            final /* synthetic */ Entity $it$inlined;
                            final /* synthetic */ Ref.ObjectRef $found$inlined;
                            final /* synthetic */ Ref.BooleanRef $allowAllOrigins$inlined;
                            {
                                this.$it$inlined = entity;
                                this.$found$inlined = objectRef;
                                this.$allowAllOrigins$inlined = booleanRef;
                                super(1);
                            }

                            public final Unit invoke(@NotNull TransientStoreSession it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                this.$found$inlined.element = (XdUser)XdExtensionsKt.toXd((Entity)this.$it$inlined);
                                BaseApplication.setSessionField((String)"SessionOrigin", (Object)"Hub token");
                                if (!jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
                                    this.$allowAllOrigins$inlined.element = true;
                                }
                                return Unit.INSTANCE;
                            }
                        }), (int)7, null);
                    }
                }
                catch (OAuthException e) {
                    Error error = e.getOAuthError();
                    String message = "Got invalid Hub authentication token: " + authHeaderValue + ". Error: " + (error == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getOAuthError().getDeveloperMessage());
                    Companion.getLogger().warn(message);
                    throw (Throwable)new NotAuthorizedException((Object)message, new Object[0]);
                }
            }
            TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>((Ref.ObjectRef)found, authHeaderValue){
                final /* synthetic */ Ref.ObjectRef $found$inlined;
                final /* synthetic */ String $authHeaderValue$inlined;
                {
                    this.$found$inlined = objectRef;
                    this.$authHeaderValue$inlined = string;
                    super(1);
                }

                public final Unit invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if ((XdUser)this.$found$inlined.element == null && this.$authHeaderValue$inlined != null && StringsKt.startsWith$default((String)this.$authHeaderValue$inlined, (String)"Basic ", (boolean)false, (int)2, null)) {
                        String string = this.$authHeaderValue$inlined;
                        int n = "Basic ".length();
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String authString = string3;
                        byte[] byArray = Base64.getDecoder().decode(authString);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(authString)");
                        byte[] byArray2 = byArray;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                        Charset charset2 = charset;
                        String encoded = new String(byArray2, charset2);
                        List credentials = StringsKt.split$default((CharSequence)encoded, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                        if (credentials.size() == 2) {
                            LoginContext context = new LoginContext((String)CollectionsKt.first((List)credentials), (String)CollectionsKt.last((List)credentials));
                            Entity entity = jetbrains.charisma.persistent.BeansKt.getAuthenticationManager().authorize(context);
                            this.$found$inlined.element = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
                        }
                    }
                    return Unit.INSTANCE;
                }
            }), (int)7, null);
            TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>((Ref.ObjectRef)found, req){
                final /* synthetic */ Ref.ObjectRef $found$inlined;
                final /* synthetic */ ContainerRequestContext $req$inlined;
                {
                    this.$found$inlined = objectRef;
                    this.$req$inlined = containerRequestContext;
                    super(1);
                }

                public final Unit invoke(@NotNull TransientStoreSession it) {
                    Unit unit;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if ((XdUser)this.$found$inlined.element == null) {
                        Entity entity = jetbrains.charisma.persistent.BeansKt.getLoggedInUserOrNull();
                        if (entity == null) {
                            entity = jetbrains.charisma.service.BeansKt.getUserService().getGuest();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"(loggedInUserOrNull ?: userService.guest)");
                        this.$found$inlined.element = (XdUser)XdExtensionsKt.toXd((Entity)entity);
                    }
                    XdUser xdUser = (XdUser)this.$found$inlined.element;
                    if (xdUser != null) {
                        XdUser xdUser2;
                        XdUser it2 = xdUser2 = xdUser;
                        UriInfo uriInfo = this.$req$inlined.getUriInfo();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                        String string = uriInfo.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"req.uriInfo.path");
                        String path = StringsKt.removeSuffix((String)string, (CharSequence)"/");
                        if (it2.getBanned() && !RESTLoginRequestFilter.access$getALLOWED_TO_BANNED_LOCATIONS$cp().contains(path)) {
                            boolean bl;
                            block10: {
                                Iterable $receiver$iv = RESTLoginRequestFilter.access$getALLOWED_TO_BANNED_LOCATIONS_PREFIX$cp();
                                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $receiver$iv) {
                                        String prefix = (String)element$iv;
                                        if (!StringsKt.startsWith$default((String)path, (String)prefix, (boolean)false, (int)2, null)) continue;
                                        bl = true;
                                        break block10;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) {
                                if (it2.isGuest()) {
                                    throw (Throwable)new UnauthorizedException("You are not logged in.");
                                }
                                throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("User_is_banned", new Object[0]));
                            }
                        }
                        BeansKt.getSecurityNavigator().login((Object)it2.getEntity(), false);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
            }), (int)7, null);
        }
        YouTrackCORSContainerResponseFilter.Companion.getALLOW_ALL_ORIGINS().set(allowAllOrigins.element);
        Companion.getLogger().debug((Function0)new Function0<String>(req){
            final /* synthetic */ ContainerRequestContext $req;

            @NotNull
            public final String invoke() {
                ContainerRequestContext containerRequestContext = this.$req;
                StringBuilder builder = new StringBuilder("Rest request: ").append(containerRequestContext != null && (containerRequestContext = containerRequestContext.getUriInfo()) != null ? containerRequestContext.getRequestUri() : null);
                if (RESTLoginRequestFilter.Companion.getLogger().isTraceEnabled()) {
                    StringBuilder stringBuilder = builder;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"builder");
                    ContainerRequestContext containerRequestContext2 = this.$req;
                    StringsKt.appendln((StringBuilder)stringBuilder).append(containerRequestContext2 != null ? containerRequestContext2.getHeaders() : null);
                }
                return builder.toString();
            }
            {
                this.$req = containerRequestContext;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        ALLOWED_TO_BANNED_LOCATIONS = SetsKt.setOf((Object[])new String[]{"config", "token", "admin/users/me", "analytics", "user/login", "user/current"});
        ALLOWED_TO_BANNED_LOCATIONS_PREFIX = SetsKt.setOf((Object)"networkedhelpdesk");
    }

    @NotNull
    public static final /* synthetic */ Set access$getALLOWED_TO_BANNED_LOCATIONS$cp() {
        return ALLOWED_TO_BANNED_LOCATIONS;
    }

    @NotNull
    public static final /* synthetic */ Set access$getALLOWED_TO_BANNED_LOCATIONS_PREFIX$cp() {
        return ALLOWED_TO_BANNED_LOCATIONS_PREFIX;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/webapp/filters/RESTLoginRequestFilter$Companion;", "Lmu/KLogging;", "()V", "ALLOWED_TO_BANNED_LOCATIONS", "", "", "ALLOWED_TO_BANNED_LOCATIONS_PREFIX", "API_KEY_HEADER", "API_KEY_PARAM", "AUTHORIZATION_HEADER", "getApiKey", "req", "Ljavax/ws/rs/container/ContainerRequestContext;", "youtrack-webapp"})
    public static final class Companion
    extends KLogging {
        private final String getApiKey(ContainerRequestContext req) {
            String string = req.getHeaderString(RESTLoginRequestFilter.API_KEY_HEADER);
            if (string == null) {
                UriInfo uriInfo = req.getUriInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                string = (String)uriInfo.getQueryParameters().getFirst((Object)RESTLoginRequestFilter.API_KEY_PARAM);
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

