/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.webapp.listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jetbrains.charisma.main.YouTrackInit;
import jetbrains.charisma.main.YouTrackShutdown;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.logging.MultiplexingFileAppender;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.WebLocalScope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/webapp/listeners/ServletContextDestroyListener;", "Ljavax/servlet/ServletContextListener;", "()V", "contextDestroyed", "", "sce", "Ljavax/servlet/ServletContextEvent;", "contextInitialized", "getDomain", "", "Companion", "youtrack-webapp"})
public class ServletContextDestroyListener
implements ServletContextListener {
    public static final Companion Companion = new Companion(null);

    public void contextInitialized(@NotNull ServletContextEvent sce) {
        Intrinsics.checkParameterIsNotNull((Object)sce, (String)"sce");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(@NotNull ServletContextEvent sce) {
        block13: {
            Intrinsics.checkParameterIsNotNull((Object)sce, (String)"sce");
            MDC.put((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY, (Object)sce.getServletContext());
            MDC.put((String)"domain", (String)sce.getServletContext().getInitParameter("domain"));
            try {
                Companion.getLogger().info("Destroyed event for context " + this.getDomain(sce));
                ServletContext servletContext = sce.getServletContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)servletContext, (String)"sce.servletContext");
                if (YouTrackInit.INSTANCE.isInitStarted(servletContext)) {
                    try {
                        BaseApplication.setServletContext((ServletContext)sce.getServletContext());
                        YouTrackShutdown.shutdown();
                        if (ServiceLocator.isInited()) {
                            ServiceLocator.closeLocal();
                        }
                        break block13;
                    }
                    finally {
                        BaseApplication.setServletContext(null);
                    }
                }
                Companion.getLogger().info(this.getDomain(sce) + " was not started, skipping destroy event");
            }
            finally {
                MDC.remove((String)WebLocalScope.MDC_SERVLET_CONTEXT_KEY);
                MDC.remove((String)"domain");
                try {
                    MultiplexingFileAppender.Companion.stop(this.getDomain(sce));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final String getDomain(@NotNull ServletContextEvent $receiver) {
        String string = $receiver.getServletContext().getInitParameter("domain");
        if (string == null) {
            string = "local";
        }
        return string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/webapp/listeners/ServletContextDestroyListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-webapp"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

