/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.api;

import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.api.workflow.annotations.ApiDocReturns;
import jetbrains.youtrack.api.workflow.annotations.ApiMethod;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiScope;
import jetbrains.youtrack.api.workflow.annotations.ApiSince;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.workflow.persistence.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\n\b\u0001\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0002H\u0007\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0007\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002H\u0007\u00a8\u0006\t"}, d2={"findFieldByName", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "Ljetbrains/youtrack/persistent/XdProject;", "name", "", "getName", "getNotificationEmail", "getTeam", "Ljetbrains/youtrack/persistent/XdUserGroup;", "youtrack-workflow"})
public final class ProjectWorkflowApiExtensionKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="The email address that is used to send notifications for the project.\nIf a 'From' address is not set for the project, the default 'From' address for the YouTrack server is returned.\n@example\nif (issue.becomesReported) {\n  var lastRelatedEmails = issue.fields['Last message related emails'];\n  if (lastRelatedEmails) {\n    lastRelatedEmails.split(' ').forEach(function (email) {\n      if (email && email.equalsIgnoreCase(issue.project.notificationEmail)) {\n        var allRelatedEmails = issue.fields['All related emails'];\n        if (!allRelatedEmails) {\n          issue.fields['All related emails'] = email;\n        } else if (!(allRelatedEmails.split(' ').has(email))) {\n          issue.fields['All related emails'] = allRelatedEmails + ' ' + email;\n        }\n      }\n    });\n    issue.fields['Last message related emails'] = null;\n  }\n}")
    @Nullable
    public static final String getNotificationEmail(@NotNull XdProject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return BeansKt.getNotificationProvider().getFromEmailFor($receiver.getEntity());
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="The name of the project.")
    @ApiMpsIgnore
    @NotNull
    public static final String getName(@NotNull XdProject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getName();
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Returns the custom field in the project with the specified name.")
    @ApiDocReturns(value="The custom field with the specified name.")
    @Nullable
    public static final XdProjectCustomField findFieldByName(@NotNull XdProject $receiver, @ApiDoc(value="The name of the custom field.") @Nullable String name2) {
        XdCustomFieldPrototype prototype;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = name2;
        if (string == null) {
            return null;
        }
        XdCustomFieldPrototype xdCustomFieldPrototype = prototype = XdCustomFieldPrototype.Companion.findPrototype(string);
        return xdCustomFieldPrototype != null ? xdCustomFieldPrototype.getProjectCustomField($receiver) : null;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2017.4.38235")
    @ApiDoc(value="A UserGroup object that contains the users and members of groups who are assigned to the project team.")
    @Nullable
    public static final XdUserGroup getTeam(@NotNull XdProject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Entity entity = BeansKt.getRingTeamApi().getProjectTeam($receiver.getEntity());
        return entity != null ? (XdUserGroup)XdExtensionsKt.toXd((Entity)entity) : null;
    }
}

