/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker.problem.fix;

import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.plugin.XdCustomFieldType;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.workflow.checker.problem.fix.AddValuesUtilKt;
import jetbrains.youtrack.workflow.checker.problem.fix.QuickFix;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.function.HtmlStringUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/workflow/checker/problem/fix/CreateFieldFix;", "Ljetbrains/youtrack/workflow/checker/problem/fix/QuickFix;", "xdProject", "Ljetbrains/youtrack/persistent/XdProject;", "fieldName", "", "fieldType", "Ljetbrains/charisma/customfields/plugin/XdCustomFieldType;", "valueNames", "", "(Ljetbrains/youtrack/persistent/XdProject;Ljava/lang/String;Ljetbrains/charisma/customfields/plugin/XdCustomFieldType;Ljava/lang/Iterable;)V", "description", "getDescription", "()Ljava/lang/String;", "getValueNames", "()Ljava/lang/Iterable;", "apply", "", "isAccessible", "", "user", "Ljetbrains/youtrack/persistent/XdUser;", "youtrack-workflow"})
public final class CreateFieldFix
implements QuickFix {
    private final XdProject xdProject;
    private final String fieldName;
    private final XdCustomFieldType<?> fieldType;
    @Nullable
    private final Iterable<String> valueNames;

    @Override
    public void apply() {
        XdProjectCustomField field = this.fieldType.getXdPrototype(this.fieldName).findOrCreateProjectCustomField(this.xdProject);
        Iterable iterable = this.valueNames;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        AddValuesUtilKt.addValues(field, iterable);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("CreateOrAttachFieldFix.Create_and_attach_custom_field_of_{0}_type_to_project_{1}", new Object[]{"<span class=\"bold\">" + HtmlStringUtil.html((Object)this.fieldType.getNamePresentation()) + "</span>", "<span class=\"bold\">" + HtmlStringUtil.html((Object)this.xdProject.getName()) + "</span>"});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026xdProject.name)}</span>\")");
        return string;
    }

    @Override
    public boolean isAccessible(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return this.xdProject.isAccessible(Operation.UPDATE, user) || user.hasPermission(Permission.ADMIN_UPDATE_APP);
    }

    @Nullable
    public final Iterable<String> getValueNames() {
        return this.valueNames;
    }

    public CreateFieldFix(@NotNull XdProject xdProject, @NotNull String fieldName, @NotNull XdCustomFieldType<?> fieldType, @Nullable Iterable<String> valueNames) {
        Intrinsics.checkParameterIsNotNull((Object)xdProject, (String)"xdProject");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull(fieldType, (String)"fieldType");
        this.xdProject = xdProject;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.valueNames = valueNames;
    }
}

