/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.model;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.scripts.wrappers.EntityValueResolver;
import jetbrains.youtrack.scripts.wrappers.ValueResolveUtil;
import jetbrains.youtrack.workflow.model.BooleanExpression;
import jetbrains.youtrack.workflow.model.EqualNode;
import jetbrains.youtrack.workflow.model.NodeBaseWrapper;
import org.jetbrains.annotations.NotNull;

public class WhereBuilder {
    private String entityType;
    private Entity project;

    public WhereBuilder(Entity project2) {
        this.project = project2;
        this.entityType = "Issue";
    }

    private WhereBuilder(String entityType) {
        this.entityType = entityType;
    }

    protected String getFieldDbName(String name2) {
        return this.getFieldInfo(name2).getPropertyName();
    }

    protected BooleanExpression wrap(NodeBase node) {
        return new NodeBaseWrapper(node);
    }

    @NotNull
    protected PropertyValueResolver getFieldInfo(String name2) {
        PropertyValueResolver valueResolver = ((ValueResolveUtil)ServiceLocator.getBean((String)"valueResolveUtil")).getPropertyValueResolver(null, this.project, this.getEntityType(), name2);
        if (valueResolver == null) {
            throw new LocalizedLogicException((Localization)new LocalizationObject("WhereBuilder.Can_not_resolve_property_{type}_{name}_in_project_{2}", new Object[]{this.getEntityType(), name2, PrimitiveAssociationSemantics.get((Entity)this.project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())}));
        }
        return valueResolver;
    }

    public Link link(String name2) {
        PropertyValueResolver propertyValueResolver = this.getFieldInfo(name2);
        Link link = new Link(this, propertyValueResolver.getPropertyName(), propertyValueResolver.getTypeName());
        return link;
    }

    public BooleanExpression eq(Object value2) {
        EntityValueResolver valueResolver = ((ValueResolveUtil)ServiceLocator.getBean((String)"valueResolveUtil")).getProjectEntityValueResolver(null, this.project, this.getEntityType(), false);
        return this.wrap(new EqualNode((Entity)valueResolver.unwrap(value2)));
    }

    public BooleanExpression neq(Object value2) {
        return this.wrap((NodeBase)new UnaryNot(this.eq(value2).getNode()));
    }

    public BooleanExpression eq(String name2, Object value2) {
        PropertyValueResolver propertyValueResolver = this.getFieldInfo(name2);
        if (propertyValueResolver.isPrimitive()) {
            return this.wrap((NodeBase)new PropertyEqual(propertyValueResolver.getPropertyName(), (Comparable)propertyValueResolver.unwrap(value2)));
        }
        return this.wrap((NodeBase)new LinkEqual(propertyValueResolver.getPropertyName(), (Entity)propertyValueResolver.unwrap(value2)));
    }

    public BooleanExpression neq(String name2, Object value2) {
        return this.wrap((NodeBase)new UnaryNot(this.eq(name2, value2).getNode()));
    }

    public BooleanExpression not(BooleanExpression node) {
        return this.wrap((NodeBase)new UnaryNot(node.getNode()));
    }

    public BooleanExpression pr(String name2, Object min, Object max) {
        return this.wrap((NodeBase)new PropertyRange(this.getFieldDbName(name2), (Comparable)min, (Comparable)max));
    }

    public BooleanExpression plt(String name2, Object max) {
        PropertyValueResolver resolver = this.getFieldInfo(name2);
        String propertyName = resolver.getPropertyName();
        Class type2 = resolver.getType();
        return this.wrap((NodeBase)new PropertyRange(propertyName, PrimitiveAssociationSemantics.negativeInfinity((Class)type2), PrimitiveAssociationSemantics.previousLess((Comparable)((Comparable)resolver.unwrap(max)), (Class)type2)));
    }

    public BooleanExpression pgt(String name2, Object min) {
        PropertyValueResolver resolver = this.getFieldInfo(name2);
        String propertyName = resolver.getPropertyName();
        Class type2 = resolver.getType();
        return this.wrap((NodeBase)new PropertyRange(propertyName, PrimitiveAssociationSemantics.nextGreater((Comparable)((Comparable)resolver.unwrap(min)), (Class)type2), PrimitiveAssociationSemantics.positiveInfinity((Class)type2)));
    }

    public BooleanExpression ple(String name2, Object max) {
        PropertyValueResolver resolver = this.getFieldInfo(name2);
        String propertyName = resolver.getPropertyName();
        Class type2 = resolver.getType();
        return this.wrap((NodeBase)new PropertyRange(propertyName, PrimitiveAssociationSemantics.negativeInfinity((Class)type2), (Comparable)resolver.unwrap(max)));
    }

    public BooleanExpression pge(String name2, Object min) {
        PropertyValueResolver resolver = this.getFieldInfo(name2);
        String propertyName = resolver.getPropertyName();
        Class type2 = resolver.getType();
        return this.wrap((NodeBase)new PropertyRange(propertyName, (Comparable)resolver.unwrap(min), PrimitiveAssociationSemantics.positiveInfinity((Class)type2)));
    }

    public BooleanExpression pnn(String name2) {
        return this.wrap((NodeBase)new PropertyNotNull(name2));
    }

    public BooleanExpression and(BooleanExpression left, BooleanExpression right) {
        return this.wrap((NodeBase)new And(left.getNode(), right.getNode()));
    }

    public BooleanExpression or(BooleanExpression left, BooleanExpression right) {
        return this.wrap((NodeBase)new Or(left.getNode(), right.getNode()));
    }

    protected String getEntityType() {
        return this.entityType;
    }

    public class Link
    extends WhereBuilder
    implements BooleanExpression {
        private String linkName;
        private WhereBuilder parent;

        public Link(WhereBuilder parent, String linkName, String entityType) {
            super(entityType);
            this.parent = parent;
            this.linkName = linkName;
        }

        @Override
        public BooleanExpression wrap(NodeBase node) {
            return this.parent.wrap((NodeBase)new LinksEqualDecorator(this.linkName, node, this.getEntityType()));
        }

        @Override
        public NodeBase getNode() {
            return this.parent.wrap((NodeBase)new PropertyEqual(this.linkName, (Comparable)Boolean.TRUE)).getNode();
        }
    }
}

