/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.scripts.loader.ScriptFile;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.loader.ScriptsLoader;
import jetbrains.youtrack.scripts.persistence.ScriptImpl;
import jetbrains.youtrack.scripts.persistence.WorkflowImpl;
import jetbrains.youtrack.workflow.ObsoleteScriptUsageMethods;

public class CloneScriptLoader
extends ScriptsLoader {
    private static final String WF_NAME = "@jetbrains/youtrack-workflow-clone-issue";
    private static final String OBSOLETE_WF_NAME = "jetbrains-youtrack-cloneIssue";
    private static final String WF_TITLE = "Clone Issue";
    private static final String RULE_NAME = "clone";
    private static final String PATH = "jetbrains/youtrack/workflow/clone/clone.js";
    public static final String FQ_RULE_NAME = "@jetbrains/youtrack-workflow-clone-issue/clone";

    protected Iterable<ScriptSource> getScripts() {
        return Sequence.singleton((Object)new ScriptFile((this.isBrandNewCloneThere() ? WF_NAME : OBSOLETE_WF_NAME) + "/" + RULE_NAME, ((Object)((Object)this)).getClass().getClassLoader().getResource(PATH)).setVersion(0).setAutoAttached(true).setTitle(WF_TITLE));
    }

    public void load() {
        if (this.isBrandNewCloneThere()) {
            super.load();
            return;
        }
        Entity wf = WorkflowImpl.find((String)OBSOLETE_WF_NAME);
        if (!EntityOperations.equals((Entity)wf, null)) {
            PrimitiveAssociationSemantics.set((Entity)wf, (String)"name", (Comparable)((Object)WF_NAME), String.class);
            PrimitiveAssociationSemantics.set((Entity)wf, (String)"title", (Comparable)((Object)WF_TITLE), String.class);
            PrimitiveAssociationSemantics.set((Entity)QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)wf, (String)"rules")), (String)"name", (Comparable)((Object)RULE_NAME), String.class);
            super.load();
        } else {
            TreeKeepingEntityIterable projects2;
            wf = WorkflowImpl.find((String)RULE_NAME);
            if (!EntityOperations.equals((Entity)wf, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)wf, (String)"readOnly", Boolean.class, null)).booleanValue()) {
                wf = WorkflowImpl.find((String)"clone_0");
            }
            if (!EntityOperations.equals((Entity)wf, null)) {
                projects2 = Sequence.fromIterable(this.getProjectUsages(wf)).toListSequence();
                EntityOperations.remove((Entity)wf);
            } else {
                projects2 = QueryOperations.queryGetAll((String)"Project");
            }
            super.load();
            wf = WorkflowImpl.find((String)WF_NAME);
            PrimitiveAssociationSemantics.set((Entity)wf, (String)"title", (Comparable)((Object)WF_TITLE), String.class);
            PrimitiveAssociationSemantics.set((Entity)wf, (String)"autoAttach", (Comparable)Boolean.valueOf(true), Boolean.class);
            PrimitiveAssociationSemantics.set((Entity)wf, (String)"allowAutoUpdate", (Comparable)Boolean.valueOf(true), Boolean.class);
            final Entity theScript = QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)wf, (String)"rules"));
            final ObsoleteScriptUsageMethods methods = (ObsoleteScriptUsageMethods)ServiceLocator.getBean((String)"scriptUsageMethods");
            Sequence.fromIterable((Iterable)projects2).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    methods.attach(it, theScript);
                }
            });
        }
    }

    protected void packageProcessed(Entity pkg) {
        String name2 = WF_NAME;
        if (CloneScriptLoader.neq_8qslp_a0b0c(PrimitiveAssociationSemantics.get((Entity)pkg, (String)"name", String.class, null), WF_NAME)) {
            PrimitiveAssociationSemantics.set((Entity)pkg, (String)"name", (Comparable)((Object)WF_NAME), String.class);
        }
        Entity rule2 = QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)pkg, (String)"rules"));
        String hash = ScriptImpl.calculateScriptHash((String)PrimitiveAssociationSemantics.getBlobAsString((Entity)rule2, (String)"script"));
        if (CloneScriptLoader.neq_8qslp_a0e0c(PrimitiveAssociationSemantics.get((Entity)rule2, (String)"originalHash", String.class, null), hash)) {
            PrimitiveAssociationSemantics.set((Entity)rule2, (String)"originalHash", (Comparable)((Object)hash), String.class);
        }
    }

    private boolean isBrandNewCloneThere() {
        return !EntityOperations.equals((Entity)WorkflowImpl.find((String)WF_NAME), null);
    }

    private Iterable<Entity> getProjectUsages(Entity wf) {
        final ObsoleteScriptUsageMethods methods = (ObsoleteScriptUsageMethods)ServiceLocator.getBean((String)"scriptUsageMethods");
        return QueryOperations.distinct((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)wf, (String)"rules")).translate((_FunctionTypes._return_P1_E0)new ITranslator2<Entity, Entity>(){

            public Iterable<Entity> translate(Entity it) {
                return methods.getAttachedProjects(it);
            }
        }));
    }

    private static boolean neq_8qslp_a0b0c(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean neq_8qslp_a0e0c(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

