(function() {
  var toArray = function(list) {
    return list ? list.toArray() : [];
  };
  var findEntityLocator = function(typeName) {
    if (typeName === 'User') {
      return 'findByLogin';
    } else if (typeName === 'Issue') {
      return 'findById';
    } else if (typeName === 'IssueTag'){
      return 'findTagByName';
    } else if (typeName === 'SavedQuery'){
      return 'findQueryByName';
    } else {
      return 'findByName';
    }
  };
  var findFieldLocator = function(typeName) {
    if (typeName === 'User') {
      return 'findValueByLogin';
    } else {
      return 'findValueByName';
    }
  };
  return function (realFunction) {
    var entities = require('@jetbrains/youtrack-scripting-api/entities');
    return function (env) {
      var issue = new entities.Issue(env.getIssue());
      var ctx = Object.defineProperties({}, {
        issue: {
          enumerable: true,
          value: issue,
          writable: false
        },
        currentUser: {
          enumerable: true,
          get: function () {
            return entities.User.current
          }
        },
        isSilentOperation: {
          enumerable: true,
          get: function() {
            return env.isSilent();
          }
        }
      });

      toArray(env.getRequirements()).forEach(function (r) {
        var c = 0;
        var keys = toArray(r.getCtxKeys());
        toArray(r.getValues()).forEach(function (val) {
          ctx[keys[c++]] = entities[r.getName()][findEntityLocator(r.getName())](val);
        });

        toArray(r.getFields()).filter(function (requirement) {
          return requirement.getType().getName() !== 'IssueLinkPrototype';
        }).forEach(function (fieldRequirement) {
          var fieldName = fieldRequirement.getName();
          var field = issue.project.findFieldByName(fieldName);
          ctx[fieldRequirement.getCtxKey()] = field;
          if (!issue.fields.hasOwnProperty(fieldRequirement.getCtxKey())) {
            Object.defineProperty(issue.fields, fieldRequirement.getCtxKey(), {
              get: function () {
                return issue[field.name];
              },
              set: function (val) {
                issue[field.name] = val;
              }
            });
          }

          var c = 0;
          var keys = toArray(fieldRequirement.getType().getCtxKeys());
          toArray(fieldRequirement.getType().getValues()).forEach(function (value) {
            field[keys[c++]] = field[findFieldLocator(fieldRequirement.getType().getName())](value);
          });
        });

        toArray(r.getFields()).filter(function (requirement) {
          return requirement.getType().getName() === 'IssueLinkPrototype';
        }).forEach(function (linkRequirement) {
          var fieldName = linkRequirement.getName();
          ctx[linkRequirement.getCtxKey()] = entities.IssueLinkPrototype.findByName(fieldName);
        });
      });

      return !!realFunction(ctx);
    };
  };
})();