var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Clear fix versions when state changes to "Can\'t reproduce", "Duplicate", "Won\'t fix", "Incomplete", or "Obsolete"'),
  guard: function(ctx) {
    return ctx.issue.fields.isChanged(ctx.State);
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var states = [ctx.State.CantReproduce, ctx.State.Duplicate, ctx.State.WontFix, ctx.State.Incomplete, ctx.State.Obsolete];
    if (states.filter(function(state) {
        return issue.fields.becomes(ctx.State, state);
      }).length && issue.fields.FixVersions.isNotEmpty()) {
      issue.fields.FixVersions.clear();
      workflow.message(workflow.i18n('\'Fix versions\' have been cleared.'));
    }
  },
  requirements: {
    FixVersions: {
      name: 'Fix versions',
      type: entities.ProjectVersion.fieldType,
      multi: true
    },
    State: {
      type: entities.State.fieldType,
      CantReproduce: {
        name: 'Can\'t reproduce'
      },
      Duplicate: {},
      WontFix: {
        name: 'Won\'t Fix'
      },
      Incomplete: {},
      Obsolete: {}
    }
  }
});