var entities = require('@jetbrains/youtrack-scripting-api/entities');
var utils = require('./attach-file-utils');

exports.rule = entities.Issue.onChange({
  title: 'Check description for reference to attachment',
  guard: function(ctx) {
    return ctx.issue.becomesReported || ctx.issue.isChanged('description'); // optimize blob (description) read
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var description = issue.description;
    if (!description) {
      return;
    }

    if (issue.becomesReported && ctx.issue.attachments.isEmpty()) {
      utils.findAndShowMessage(description);
      return;
    }
    if (issue.isChanged('description')) {
      var oldDescription = issue.oldValue('description') || '';
      var found = '';
      if (utils.words.some(function(word) {
          if ((description.indexOf(word) > -1) && (oldDescription.indexOf(word) === -1)) {
            found = word;
            return true;
          }
          return false;
        })) {
        utils.showMessage(found);
      }
    }
  }
});