var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Add "refers to" link to an issue when the issue ID is added to a description or comment'),
  guard: function(ctx) {
    return !ctx.issue.comments.added.isEmpty() || ctx.issue.isChanged('description');
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var startGroup = /(^|[',;.:"\\()?!<>#+|/\[\]\t\n\r ])/;
    var endGroup = /([',;.:"\\()?!<>#+|/\[\]\t\n\r ]|$)/;
    var issueIdGroup = '(' + issue.project.key.toLowerCase() + '-\\d+)';
    var regexp = new RegExp(startGroup.source + issueIdGroup + endGroup.source, 'i');
    var text = issue.comments.added.isEmpty() ? issue.description : issue.comments.added.first().text;
    var match = regexp.exec(text);
    var allMentionedIssues = {};
    while (match) {
      var matchedIssueId = match[2].trim();
      var referringIssue = entities.Issue.findById(matchedIssueId);
      if (referringIssue !== null) {
        issue.links[ctx.RefersTo.outward].add(referringIssue);
        allMentionedIssues[matchedIssueId] = true;
      }
      text = text.substring(match.index + match[0].length);
      match = regexp.exec(text);
    }
    var allAddedIssues = Object.keys(allMentionedIssues);
    if (allAddedIssues.length) {
      workflow.message(workflow.i18n('Automatically added \'refers to\' {0} links.', allAddedIssues.join()));
    }
  },
  requirements: {
    RefersTo: {
      type: entities.IssueLinkPrototype,
      name: 'Refers',
      outward: 'refers to'
    }
  }
});