var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var copy = require('./copy-values');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Copy fix versions from parent task when issue is linked as a subtask'),
  guard: function(ctx) {
    return !ctx.issue.links['parent for'].added.isEmpty();
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetFixVersions = function(subtask) {
      if (subtask.project && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.FixVersions.name)) {
          if (!subtask.isResolved) {
            copy.copyValues(issue.fields.FixVersions, subtask, ctx.FixVersions);
          }
        }
      }
    };

    issue.links['parent for'].added.forEach(safeSetFixVersions);

  },
  requirements: {
    FixVersions: {
      type: entities.ProjectVersion.fieldType,
      name: 'Fix versions',
      multi: true
    }
  }
});