var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Assign issue to current user when state changes to in progress'),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.InProgress) && !ctx.issue.fields.Assignee;
  },
  action: function(ctx) {
    ctx.issue.fields.Assignee = ctx.currentUser;
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      InProgress: {
        name: 'In Progress'
      }
    },
    Assignee: {
      type: entities.User.fieldType
    }
  }
});