var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Start timer when issue is in progress'),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.InProgress);
  },
  action: function(ctx) {
    ctx.issue.fields.TimerTime = Date.now();
    workflow.message(workflow.i18n('The timer is started.'));
  },
  requirements: {
    TimerTime: {
      type: entities.Field.dateTimeType,
      name: 'Timer time'
    },
    State: {
      type: entities.State.fieldType,
      InProgress: {
        name: 'In Progress'
      }
    }
  }
});