/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk;

import jetbrains.charisma.persistent.CompetitorIssueLinksProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.zendesk.persistent.ExtensionsKt;
import jetbrains.youtrack.zendesk.persistent.XdAgreement;
import jetbrains.youtrack.zendesk.persistent.XdTicketSharingInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/zendesk/ZendeskIssueLinksProvider;", "Ljetbrains/charisma/persistent/CompetitorIssueLinksProvider;", "()V", "sharingInfo", "Ljetbrains/youtrack/zendesk/persistent/XdTicketSharingInfo;", "Ljetbrains/exodus/entitystore/Entity;", "getSharingInfo", "(Ljetbrains/exodus/entitystore/Entity;)Ljetbrains/youtrack/zendesk/persistent/XdTicketSharingInfo;", "accept", "", "issue", "getCommentsKey", "", "i", "getCommentsUrl", "getHistoryKey", "getHistoryUrl", "getIssueKey", "getIssueUrl", "agreement", "Ljetbrains/youtrack/zendesk/persistent/XdAgreement;", "ticketId", "", "name", "youtrack-zendesk-integration"})
public final class ZendeskIssueLinksProvider
implements CompetitorIssueLinksProvider {
    private final XdTicketSharingInfo getSharingInfo(@NotNull Entity $receiver) {
        return ExtensionsKt.getTicketInfo((XdIssue)XdExtensionsKt.toXd((Entity)$receiver));
    }

    @NotNull
    public String name() {
        return "Zendesk";
    }

    public boolean accept(@NotNull Entity issue2) {
        XdTicketSharingInfo xdTicketSharingInfo;
        XdTicketSharingInfo it;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo2 = this.getSharingInfo(issue2);
        return xdTicketSharingInfo2 != null ? (it = (xdTicketSharingInfo = xdTicketSharingInfo2)).getOriginalId() != 0 : false;
    }

    @NotNull
    public String getIssueKey(@NotNull Entity issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo = this.getSharingInfo(issue2);
        return "Ticket " + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null);
    }

    @NotNull
    public String getIssueUrl(@NotNull Entity issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo = this.getSharingInfo(issue2);
        if (xdTicketSharingInfo == null) {
            return "";
        }
        XdTicketSharingInfo sharingInfo2 = xdTicketSharingInfo;
        return this.getIssueUrl(sharingInfo2.getAgreement(), sharingInfo2.getOriginalId());
    }

    @NotNull
    public final String getIssueUrl(@NotNull XdAgreement agreement, int ticketId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agreement), (String)"agreement");
        return StringsKt.replace$default((String)agreement.getSenderUrl(), (String)"/sharing", (String)("/agent/tickets/" + ticketId), (boolean)false, (int)4, null);
    }

    @NotNull
    public String getCommentsUrl(@NotNull Entity issue2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
                object = this.getSharingInfo(issue2);
                if (object == null || (object = object.getAgreement()) == null || (object = ((XdAgreement)((Object)object)).getSenderUrl()) == null) break block2;
                XdTicketSharingInfo xdTicketSharingInfo = this.getSharingInfo(issue2);
                if ((object = StringsKt.replace$default((String)object, (String)"/sharing", (String)("/agent/tickets/" + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null)), (boolean)false, (int)4, null)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public String getCommentsKey(@Nullable Entity i) {
        return BeansKt.getLocalizer().localizedMsgInServerLocale("Zendesk.Shared_ticket_comments_link", new Object[0]);
    }

    @NotNull
    public String getHistoryUrl(@NotNull Entity issue2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
                object = this.getSharingInfo(issue2);
                if (object == null || (object = object.getAgreement()) == null || (object = ((XdAgreement)((Object)object)).getSenderUrl()) == null) break block2;
                XdTicketSharingInfo xdTicketSharingInfo = this.getSharingInfo(issue2);
                if ((object = StringsKt.replace$default((String)object, (String)"/sharing", (String)("/agent/tickets/" + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null) + "/events"), (boolean)false, (int)4, null)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public String getHistoryKey(@Nullable Entity i) {
        return BeansKt.getLocalizer().localizedMsgInServerLocale("Zendesk.Shared_ticket_history_link", new Object[0]);
    }
}

