/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.service.util.StatusException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleVersion {
    private static final String BUNDLE_VERSION_PROPERTY = "bundle.build.number";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Properties myProperties = new Properties();

    public BundleVersion(BundleEnvironment environment) {
        Path bundleVersionsPath = environment.getBundleHome().resolve("version.properties");
        if (Files.isReadable(bundleVersionsPath)) {
            this.LOG.debug(String.format("Reading Bundle version from %s", bundleVersionsPath));
            try (InputStream is = Files.newInputStream(bundleVersionsPath, new OpenOption[0]);){
                this.myProperties.load(is);
            }
            catch (IOException e) {
                throw new StatusException("Could not load Bundle versions from " + bundleVersionsPath + ": " + e.getMessage());
            }
            if (!this.myProperties.containsKey(BUNDLE_VERSION_PROPERTY)) {
                this.LOG.warn(String.format("Can not read property %s from file %s", BUNDLE_VERSION_PROPERTY, bundleVersionsPath));
            }
        } else {
            this.LOG.debug(String.format("Bundle versions file does not exists at %s", bundleVersionsPath));
        }
    }

    String getBundleVersion() {
        return this.myProperties.getProperty(BUNDLE_VERSION_PROPERTY);
    }
}

