/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubPropertiesProvider
implements PropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HubPropertiesProvider.class);
    private static final String ADMIN_UUID_PROPERTY = "admin.uuid";
    private static final String SERVICE_ID_PROPERTY = "service.id";
    private static final String SERVICE_SECRET_PROPERTY = "service.secret";
    private static final String HUB_PROPERTIES_FILE_NAME = "hub.properties";
    private static final String HUB_BASE_URL_PREFIXED_PROPERTY = PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName("hub", "base-url");
    @Deprecated
    private static final String DEFAULT_CONFIGURATION_MODE = "configuration.mode.default";
    @Deprecated
    private static final String CONFIGURATION_MODE = "configuration.mode";
    private static final String RESET_PROPERTY = "reset";
    private final Properties myProperties;
    private final Collection<ServiceDescriptor> myAllServices;
    private final BundleEnvironment myBundleEnvironment;
    private final boolean myIsInternalHubEnabled;
    private final boolean myHubCanBeUsedByExternalServices;
    private boolean myHubConfigured;

    public HubPropertiesProvider(BundleEnvironment bundleEnvironment, Collection<ServiceDescriptor> allServices, BundleProperties bundleProperties) {
        this.myAllServices = allServices;
        this.myBundleEnvironment = bundleEnvironment;
        this.myIsInternalHubEnabled = HubPropertiesProvider.hasHubService(allServices) && bundleProperties.isServiceEnabled("hub");
        boolean bl = this.myHubConfigured = this.myIsInternalHubEnabled || bundleProperties.getHubUrl() != null;
        if (this.myHubConfigured) {
            this.myProperties = HubPropertiesProvider.ensureAllProperties(bundleEnvironment, allServices);
        } else {
            List<ServiceDescriptor> hubServices = HubPropertiesProvider.getHubServices(this.myAllServices);
            if (hubServices.isEmpty()) {
                this.myProperties = new Properties();
            } else {
                StringBuilder serviceNames = new StringBuilder();
                for (ServiceDescriptor hubService : hubServices) {
                    serviceNames.append(" [").append(hubService.getId()).append(']');
                }
                throw new IllegalStateException("Bundled Hub service is disabled, and no external Hub URL is configured, but hub is required for service(s): " + serviceNames);
            }
        }
        this.myHubCanBeUsedByExternalServices = bundleProperties.hubCanBeUsedByExternalServices();
    }

    private static boolean hasHubService(Collection<ServiceDescriptor> allServices) {
        for (ServiceDescriptor descriptor : allServices) {
            if (!descriptor.getId().equals("hub")) continue;
            return true;
        }
        return false;
    }

    private static List<ServiceDescriptor> getHubServices(Collection<ServiceDescriptor> allServices) {
        ArrayList<ServiceDescriptor> result = new ArrayList<ServiceDescriptor>();
        for (ServiceDescriptor descriptor : allServices) {
            if (descriptor.getId().equals("hub") || !descriptor.isHubService()) continue;
            result.add(descriptor);
        }
        return result;
    }

    private static Properties ensureAllProperties(BundleEnvironment bundleEnvironment, Collection<ServiceDescriptor> allServices) {
        File configFile = HubPropertiesProvider.getConfigFile(bundleEnvironment);
        Properties properties = configFile.exists() ? ConfiguratorUtils.loadPropertiesFile((File)configFile) : new Properties();
        boolean dirty = false;
        if (properties.get(ADMIN_UUID_PROPERTY) == null) {
            properties.setProperty(ADMIN_UUID_PROPERTY, UUID.randomUUID().toString());
            dirty = true;
        }
        if (properties.get("bundle-hub-service-id") == null) {
            properties.setProperty("bundle-hub-service-id", UUID.randomUUID().toString());
            dirty = true;
        }
        if (properties.get("bundle-hub-service-secret") == null) {
            properties.setProperty("bundle-hub-service-secret", ConfiguratorUtils.randomAlphanumeric((int)50));
            dirty = true;
        }
        dirty |= properties.remove(DEFAULT_CONFIGURATION_MODE) != null;
        dirty |= properties.remove(CONFIGURATION_MODE) != null;
        for (ServiceDescriptor descriptor : HubPropertiesProvider.getHubServices(allServices)) {
            if (descriptor.getHubServiceBelongsTo() != null) continue;
            String serviceIdProperty = descriptor.getId() + "." + SERVICE_ID_PROPERTY;
            if (properties.getProperty(serviceIdProperty) == null) {
                properties.setProperty(serviceIdProperty, UUID.randomUUID().toString());
                dirty = true;
            }
            dirty |= HubPropertiesProvider.setSecretFields(properties, descriptor);
        }
        if (dirty) {
            LOG.debug("Saving Hub Properties provider settings to {}", (Object)configFile);
            HubPropertiesProvider.saveConfig(configFile, properties);
        }
        return properties;
    }

    private static File getConfigFile(BundleEnvironment bundleEnvironment) {
        return bundleEnvironment.getInternalConfDir().resolve(HUB_PROPERTIES_FILE_NAME).toFile();
    }

    private static boolean setSecretFields(Properties properties, ServiceDescriptor descriptor) {
        String secretPropertyName = descriptor.getId() + "." + SERVICE_SECRET_PROPERTY;
        String secret = properties.getProperty(secretPropertyName);
        if (secret == null) {
            secret = ConfiguratorUtils.randomAlphanumeric((int)50);
            properties.setProperty(secretPropertyName, secret);
            return true;
        }
        return false;
    }

    private static void saveConfig(File configFile, Properties properties) {
        ConfiguratorUtils.savePropertiesFile((File)configFile, (Properties)properties);
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        if (!this.myHubConfigured) {
            return;
        }
        if (descriptor.isInternal()) {
            serviceProperties.setProperty("bundle-hub-service-id", this.myProperties.getProperty("bundle-hub-service-id"));
            serviceProperties.setProperty("bundle-hub-service-secret", this.myProperties.getProperty("bundle-hub-service-secret"));
        }
        if (descriptor.isHubService() || "hub".equals(descriptor.getId()) || "bundle-hub-configurator".equals(descriptor.getId())) {
            serviceProperties.setProperty("hub-admin-uuid", this.myProperties.getProperty(ADMIN_UUID_PROPERTY));
            serviceProperties.setProperty("hub-reset", Boolean.valueOf(this.myProperties.getProperty(RESET_PROPERTY)).toString());
        }
        HashSet<String> verifiedServiceIds = new HashSet<String>();
        String hostServiceIdInHub = null;
        String hostServiceIdInBundle = null;
        verifiedServiceIds.add(this.myProperties.getProperty("bundle-hub-service-id"));
        for (ServiceDescriptor serviceDescriptor : HubPropertiesProvider.getHubServices(this.myAllServices)) {
            Collection<String> redirectUris;
            String serviceBelongsTo = serviceDescriptor.getHubServiceBelongsTo();
            String serviceIdForHubPropertyResolution = serviceBelongsTo != null ? serviceBelongsTo : serviceDescriptor.getId();
            String serviceIdInHub = this.myProperties.getProperty(serviceIdForHubPropertyResolution + "." + SERVICE_ID_PROPERTY);
            String serviceSecretInHub = this.myProperties.getProperty(serviceIdForHubPropertyResolution + "." + SERVICE_SECRET_PROPERTY);
            String servicePropPrefix = descriptor.getId().equals(serviceDescriptor.getId()) ? "" : "service." + serviceDescriptor.getId() + ".";
            serviceProperties.setProperty(servicePropPrefix + "hub-service-id", serviceIdInHub);
            if (descriptor.getId().equals(serviceDescriptor.getId()) || descriptor.getId().equals("bundle-hub-configurator") || descriptor.getId().equals("adminService")) {
                HubPropertiesProvider.setPropertyIfNotNull(serviceProperties, servicePropPrefix + "hub-service-secret", serviceSecretInHub);
                HubPropertiesProvider.setPropertyIfNotNull(serviceProperties, servicePropPrefix + "hub-service-application-name", serviceDescriptor.getHubApplicationName());
                String hubUrl = this.getHubUrl(serviceProperties);
                HubPropertiesProvider.setPropertyIfNotNull(serviceProperties, "hub-url", hubUrl);
                HubPropertiesProvider.setPropertyIfNotNull(serviceProperties, HUB_BASE_URL_PREFIXED_PROPERTY, hubUrl);
            }
            if ((descriptor.getId().equals(serviceDescriptor.getId()) || descriptor.getId().equals("bundle-hub-configurator") || descriptor.getId().equals(serviceBelongsTo)) && !(redirectUris = serviceDescriptor.getAdditionalRedirectUris()).isEmpty()) {
                serviceProperties.setProperty(servicePropPrefix + "hub-additional-redirectUris", ConfiguratorUtils.join(redirectUris, (String)" "));
            }
            if (descriptor.getId().equals("bundle-hub-configurator")) {
                serviceProperties.setProperty(servicePropPrefix + "hub-service-name", serviceDescriptor.getHubServiceName());
                HubPropertiesProvider.setPropertyIfNotNull(serviceProperties, servicePropPrefix + "hub-service-belongs-to", serviceBelongsTo);
                serviceProperties.setProperty(servicePropPrefix + "manufacturer", serviceDescriptor.getManufacturer());
            }
            verifiedServiceIds.add(serviceIdInHub);
            if (!this.myIsInternalHubEnabled || this.myHubCanBeUsedByExternalServices || serviceDescriptor.getLicenseKey() == null) continue;
            if (hostServiceIdInHub != null) {
                throw new IllegalStateException(String.format("Hub in the bundle configured to work with the only one service with license key. But at least 2 services have license keys: '%s' and '%s'. Set '%s=true' in bundle_build.properties and check Hub license key limitations if bundle contains several services with license keys.", hostServiceIdInBundle, serviceDescriptor.getId(), "bundle.hub-used-by-external-services"));
            }
            hostServiceIdInHub = serviceIdInHub;
            hostServiceIdInBundle = serviceDescriptor.getId();
        }
        if ("hub".equals(descriptor.getId())) {
            if (!verifiedServiceIds.isEmpty()) {
                serviceProperties.setProperty("hub-verified-service-ids", this.toCommaSeparatedString(verifiedServiceIds));
            }
            if (this.myIsInternalHubEnabled && !this.myHubCanBeUsedByExternalServices) {
                if (hostServiceIdInHub != null) {
                    serviceProperties.setProperty("hub-host-service-id", hostServiceIdInHub);
                } else {
                    LOG.warn("Property '{}' is not set or set to 'false' in bundle_build.properties, but service with license key was not found!", (Object)"bundle.hub-used-by-external-services");
                }
            }
        }
    }

    protected String getHubUrl(@NotNull Properties serviceProperties) {
        String hubUrl = this.myIsInternalHubEnabled ? serviceProperties.getProperty(HUB_BASE_URL_PREFIXED_PROPERTY) : serviceProperties.getProperty(BundleProperty.HUB_URL.getPrefixedName());
        return hubUrl;
    }

    private String toCommaSeparatedString(Set<String> verifiedServiceIds) {
        StringBuilder sb = new StringBuilder();
        for (String hubServiceId : verifiedServiceIds) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(hubServiceId);
        }
        return sb.toString();
    }

    @NotNull
    static Collection<String> updatePropertiesByWizard(@NotNull Properties properties, @NotNull BundleEnvironment bundleEnvironment) {
        HashSet<String> overriddenHubProperties = new HashSet<String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith("hub_config.")) continue;
            overriddenHubProperties.add(propName);
        }
        File configFile = HubPropertiesProvider.getConfigFile(bundleEnvironment);
        Properties hubConfigProperties = configFile.exists() ? ConfiguratorUtils.loadPropertiesFile((File)configFile) : new Properties();
        boolean isDirty = false;
        for (String propName : overriddenHubProperties) {
            String hubPropertyName = propName.substring("hub_config".length() + 1);
            String oldValue = hubConfigProperties.getProperty(hubPropertyName);
            String newValue = properties.getProperty(propName);
            if ((oldValue != null || newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
            hubConfigProperties.setProperty(hubPropertyName, newValue);
            isDirty = true;
        }
        if (isDirty) {
            HubPropertiesProvider.saveConfig(configFile, hubConfigProperties);
        }
        return overriddenHubProperties;
    }

    private static void setPropertyIfNotNull(@NotNull Properties properties, @NotNull String property, @Nullable String value) {
        if (value != null) {
            properties.setProperty(property, value);
        }
    }

    public boolean updateResetFlag(boolean newValue) {
        boolean updated = HubPropertiesProvider.updateResetFlag(this.myProperties, newValue);
        if (updated) {
            HubPropertiesProvider.saveConfig(HubPropertiesProvider.getConfigFile(this.myBundleEnvironment), this.myProperties);
        }
        return updated;
    }

    private static boolean updateResetFlag(@NotNull Properties properties, boolean newValue) {
        String resetFlag = properties.getProperty(RESET_PROPERTY);
        if (resetFlag == null || newValue != Boolean.valueOf(resetFlag)) {
            properties.setProperty(RESET_PROPERTY, Boolean.valueOf(newValue).toString());
            return true;
        }
        return false;
    }

    static class BundleStartFinishedListener
    extends OnePerClassListener<StartFinishedEvent> {
        BundleStartFinishedListener() {
        }

        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
            Properties properties;
            boolean isDirty;
            File configFile = HubPropertiesProvider.getConfigFile(event.getBundleState().getEnvironment());
            if (configFile.exists() && (isDirty = HubPropertiesProvider.updateResetFlag(properties = ConfiguratorUtils.loadPropertiesFile((File)configFile), false))) {
                HubPropertiesProvider.saveConfig(configFile, properties);
            }
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
        }
    }
}

