/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.UpgradeProperties;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class UpgradePropertiesProvider
implements PropertiesProvider {
    @NotNull
    private final Collection<ServiceDescriptor> myAllServices;
    @NotNull
    private final UpgradeProperties myProperties;

    UpgradePropertiesProvider(@NotNull UpgradeProperties upgradeProperties, @NotNull Collection<ServiceDescriptor> allServices) {
        this.myAllServices = allServices;
        this.myProperties = upgradeProperties;
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        String servicePropertyPrefix = PropertiesBasedConfigurationHelper.getHelper().constructServicePrefix(descriptor.getId());
        for (String propName : this.myProperties.getProperties().stringPropertyNames()) {
            if (!this.hasServicePropertyFormat(propName)) {
                if (!descriptor.isInternal() && !propName.equals(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName())) continue;
                serviceProperties.setProperty("bundle." + propName, this.myProperties.getProperties().getProperty(propName));
                continue;
            }
            if (!descriptor.isInternal() && !propName.startsWith(servicePropertyPrefix)) continue;
            String servicePropName = propName.startsWith(servicePropertyPrefix) ? propName.substring(servicePropertyPrefix.length()) : propName;
            serviceProperties.setProperty(servicePropName, this.myProperties.getProperties().getProperty(propName));
        }
        for (ServiceDescriptor someServiceDescriptor : this.myAllServices) {
            if (someServiceDescriptor.isInternal() || !descriptor.isInternal() && !someServiceDescriptor.getId().equals(descriptor.getId())) continue;
            String prefixedPreviouslyStartedVersionPropertyName = PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(someServiceDescriptor.getId(), "previously-started-version");
            if (!this.myProperties.getProperties().containsKey(prefixedPreviouslyStartedVersionPropertyName)) {
                String previouslyStartedVersionPropertyName = someServiceDescriptor.getId().equals(descriptor.getId()) ? prefixedPreviouslyStartedVersionPropertyName.substring(servicePropertyPrefix.length()) : prefixedPreviouslyStartedVersionPropertyName;
                serviceProperties.setProperty(previouslyStartedVersionPropertyName, "unknown");
            }
            String currentVersionPropertyName = someServiceDescriptor.getId().equals(descriptor.getId()) ? "version" : PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(someServiceDescriptor.getId(), "version");
            serviceProperties.setProperty(currentVersionPropertyName, someServiceDescriptor.getVersion());
        }
    }

    private boolean hasServicePropertyFormat(String propName) {
        return PropertiesBasedConfigurationHelper.getHelper().parseServiceIdPrefix(propName) != null;
    }
}

