/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.launcher.context.holder.impl;

import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.contexts.ApplicationContext;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationContextHolderBase<T extends ApplicationContext>
implements ApplicationContextHolder {
    private final T myContext;

    public ApplicationContextHolderBase(@NotNull T context) {
        this.myContext = context;
    }

    @NotNull
    public T getContext() {
        return this.myContext;
    }

    @Override
    @NotNull
    public List<String> getArgs() {
        return this.myContext.getCommandLine().getApplicationArguments();
    }

    @Override
    public boolean isService() {
        return this.myContext.isService();
    }

    @Override
    @NotNull
    public String getLauncherScriptName() {
        return this.myContext.getAppFiles().getAppFileName();
    }

    @Override
    public boolean isRestart() {
        StartKind startKind = this.getStartKind();
        return startKind != null && startKind.isRestart();
    }

    @Override
    public abstract StartKind getStartKind();

    @Override
    public abstract void requestShutdown(@NotNull AppExitCode var1, boolean var2);

    @Override
    public abstract void requestRestart(@NotNull Map<String, String> var1);

    @Override
    @Nullable
    public abstract Map<String, String> getRestartState();

    @Override
    public boolean isDebugEnabled() {
        return this.myContext.getLogSettings().getLogLevel().isDebugEnabled();
    }

    @Override
    public File getBundleScriptFile() {
        return this.myContext.getAppFiles().getAppScriptFile();
    }
}

