/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.bundle.util.TopoSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServicesHolder {
    @NotNull
    private final List<String> mySortedServicesIds;
    @NotNull
    private final HashMap<String, ServiceBase> servicesMap = new HashMap();
    @NotNull
    private List<ServiceBase> mySortedServices = new ArrayList<ServiceBase>();
    @NotNull
    private final SortedServiceDescriptorsProvider mySortedServiceDescriptorsProvider;
    public boolean initialized;

    public ServicesHolder(@NotNull List<ServiceDescriptor> allServicesDescriptors) {
        this.mySortedServiceDescriptorsProvider = new SortedServiceDescriptorsProvider(allServicesDescriptors);
        this.mySortedServicesIds = this.mySortedServiceDescriptorsProvider.getSortedServiceIds();
    }

    public void addService(@NotNull ServiceBase service) {
        if (this.initialized) {
            throw new IllegalStateException("Service could not be added, all services hve been added already");
        }
        if (!this.mySortedServicesIds.contains(service.getDescriptor().getId())) {
            throw new IllegalStateException(String.format("Unexpected service [%s] is tried to be added. The following elements are expected: %s", service.getDescriptor().getId(), this.mySortedServicesIds.toString()));
        }
        if (this.servicesMap.containsKey(service.getDescriptor().getId())) {
            throw new IllegalStateException(String.format("Service [%s] has been added already.", service.getDescriptor().getId()));
        }
        this.servicesMap.put(service.getDescriptor().getId(), service);
        boolean bl = this.initialized = this.mySortedServicesIds.size() == this.servicesMap.size() && this.mySortedServicesIds.containsAll(this.servicesMap.keySet());
        if (this.initialized) {
            for (String id : this.mySortedServicesIds) {
                this.mySortedServices.add(this.servicesMap.get(id));
            }
            this.mySortedServices = Collections.unmodifiableList(this.mySortedServices);
        }
    }

    @Nullable
    public ServiceBase getService(@NotNull String id) {
        ServiceBase service = this.servicesMap.get(id);
        if (service == null && !this.initialized) {
            throw new IllegalStateException("Services map has not been initialized yet");
        }
        return service;
    }

    @NotNull
    public ServiceBase getNotNullService(@NotNull String id) {
        ServiceBase service = this.getService(id);
        if (service == null) {
            throw new IllegalArgumentException(String.format("Service [%s] is not found in managed service list [%s]", id, this.mySortedServicesIds));
        }
        return service;
    }

    @Nullable
    public ServiceDescriptor getServiceDescriptor(@NotNull String id) {
        ServiceBase service = this.getService(id);
        return service != null ? service.getDescriptor() : null;
    }

    @NotNull
    public List<ServiceBase> getSortedServices() {
        if (!this.initialized) {
            throw new IllegalStateException("Services map has not been initialized yet");
        }
        return this.mySortedServices;
    }

    public List<ServiceDescriptor> getSortedServiceDescriptors() {
        return this.mySortedServiceDescriptorsProvider.getSortedServiceDescriptors();
    }

    @NotNull
    public List<String> getSortedServicesIds() {
        return this.mySortedServicesIds;
    }

    @NotNull
    public Comparator<String> getServicesIdsComparator() {
        return this.mySortedServiceDescriptorsProvider;
    }

    public static class SortedServiceDescriptorsProvider
    implements Comparator<String> {
        @NotNull
        private final List<ServiceDescriptor> mySortedServiceDescriptors;
        @NotNull
        private final List<String> mySortedServiceIds;

        public SortedServiceDescriptorsProvider(@NotNull List<? extends ServiceDescriptor> descriptors) {
            this.mySortedServiceDescriptors = Collections.unmodifiableList(SortedServiceDescriptorsProvider.sortDescriptions(descriptors));
            ArrayList<String> sortedServiceIds = new ArrayList<String>();
            for (ServiceDescriptor sd : this.mySortedServiceDescriptors) {
                sortedServiceIds.add(sd.getId());
            }
            this.mySortedServiceIds = Collections.unmodifiableList(sortedServiceIds);
        }

        @Override
        public int compare(@NotNull String id1, @NotNull String id2) {
            return this.mySortedServiceIds.indexOf(id1) < 0 ? this.mySortedServiceIds.indexOf(id2) : this.mySortedServiceIds.indexOf(id1) - this.mySortedServiceIds.indexOf(id2);
        }

        @NotNull
        public List<ServiceDescriptor> getSortedServiceDescriptors() {
            return this.mySortedServiceDescriptors;
        }

        @NotNull
        public List<String> getSortedServiceIds() {
            return this.mySortedServiceIds;
        }

        static <T extends ServiceDescriptor> List<T> sortDescriptions(@NotNull List<T> descriptors) {
            HashMap predecessors = new HashMap();
            HashMap<String, ServiceDescriptor> ids = new HashMap<String, ServiceDescriptor>();
            ArrayList<T> sortedDescriptors = new ArrayList<T>(descriptors);
            Collections.sort(sortedDescriptors, new Comparator<T>(){

                @Override
                public int compare(@NotNull T o1, @NotNull T o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ServiceDescriptor descriptor : sortedDescriptors) {
                String id = descriptor.getId();
                if (ids.containsKey(id)) {
                    throw new RuntimeException("Duplicate service id: " + id);
                }
                ids.put(id, descriptor);
            }
            for (ServiceDescriptor descriptor : sortedDescriptors) {
                Collection<ServiceDescriptor> existing;
                for (String after : descriptor.getRunAfterServices()) {
                    ServiceDescriptor afterDescr = (ServiceDescriptor)ids.get(after);
                    if (afterDescr == null) continue;
                    existing = (HashSet<ServiceDescriptor>)predecessors.get(descriptor);
                    if (existing == null) {
                        existing = new HashSet<ServiceDescriptor>();
                    }
                    existing.add(afterDescr);
                    predecessors.put(descriptor, existing);
                }
                for (String before : descriptor.getRunBeforeServices()) {
                    ServiceDescriptor beforeDescr = (ServiceDescriptor)ids.get(before);
                    if (beforeDescr == null) continue;
                    existing = (Collection)predecessors.get(beforeDescr);
                    if (existing == null) {
                        existing = new HashSet();
                    }
                    existing.add(descriptor);
                    predecessors.put(beforeDescr, existing);
                }
            }
            return TopoSort.sort(sortedDescriptors, predecessors);
        }
    }
}

