/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.api.internal.backend.impl.BundleFacadeDelegate;
import com.jetbrains.bundle.api.internal.backend.impl.BundleFacadeImpl;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledInternalService;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class BundleBackendService
extends BundledInternalService {
    private static final String RUN_ID_PROPERTY = "runId";
    @NotNull
    private final BundleState myBundleState;

    public BundleBackendService(@NotNull ServiceDescriptor serviceDescriptor, String serviceStatusURL, @NotNull BundleState bundleState, @NotNull ServicesContainer hostingServletContainer) {
        super(serviceDescriptor, serviceStatusURL, bundleState.getEnvironment(), hostingServletContainer, bundleState.getContextHolder());
        this.myBundleState = bundleState;
    }

    @Override
    public void doStart() throws StartupException {
        Properties properties = this.getProperties();
        BundleFacadeImpl bundleFacade = new BundleFacadeImpl(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, BundleProperty.BACKEND_API_TOKEN.getPrefixedName()), this.myBundleState, BundleBackendPropertyProvider.getBundleBackendStorage(this.myBundleState.getEnvironment()));
        BundleFacadeDelegate.setBundleFacade(bundleFacade);
        super.doStart();
    }

    public static class BundleBackendPropertyProvider
    implements PropertiesProvider {
        private final BundleState myBundleState;
        private final List<ServiceDescriptor> myServices;

        public BundleBackendPropertyProvider(@NotNull BundleState bundleState, @NotNull List<ServiceDescriptor> services) {
            this.myBundleState = bundleState;
            this.myServices = services;
        }

        @Override
        public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
            if (BundleBackendPropertyProvider.findService(this.myServices, "bundleBackend") != null) {
                serviceProperties.setProperty(BundleProperty.BACKEND_API_TOKEN.getPrefixedName(), this.getBundleBackendToken(this.myBundleState.getEnvironment()));
            }
        }

        @NotNull
        private static File getBundleBackendStorage(@NotNull BundleEnvironment environment) {
            File confDir = environment.getInternalServiceConfDir("bundleBackend");
            return new File(confDir, "backendToken.properties");
        }

        @NotNull
        private String getBundleBackendToken(@NotNull BundleEnvironment environment) {
            return BundleBackendPropertyProvider.getToken(this.regenerateTokenIfNeeded(BundleBackendPropertyProvider.getBundleBackendStorage(environment)));
        }

        @NotNull
        private Properties regenerateTokenIfNeeded(@NotNull File bundleBackendStorageFile) {
            Properties properties = bundleBackendStorageFile.exists() ? ConfiguratorUtils.loadPropertiesFile((File)bundleBackendStorageFile) : new Properties();
            String oldToken = BundleBackendPropertyProvider.getToken(properties);
            String oldRunId = properties.getProperty(BundleBackendService.RUN_ID_PROPERTY);
            if (oldToken == null || !this.myBundleState.getContextHolder().isRestart() && !this.myBundleState.getRunId().equals(oldRunId)) {
                this.createAndStoreNewToken(bundleBackendStorageFile, properties, this.myBundleState.getRunId());
            }
            return properties;
        }

        private static String getToken(@NotNull Properties properties) {
            return properties.getProperty(BundleProperty.BACKEND_API_TOKEN.getName());
        }

        @NotNull
        private String createAndStoreNewToken(@NotNull File bundleBackendStorageFile, @NotNull Properties properties, @NotNull String currentRunId) {
            String bundleBackendToken = ConfiguratorUtils.randomAlphanumeric((int)200);
            properties.setProperty(BundleProperty.BACKEND_API_TOKEN.getName(), bundleBackendToken);
            properties.setProperty(BundleBackendService.RUN_ID_PROPERTY, currentRunId);
            ConfiguratorUtils.savePropertiesFile((File)bundleBackendStorageFile, (Properties)properties, (String)String.format("Property %s token contains a key that could be used to call internal Bundle backend API", BundleProperty.BACKEND_API_TOKEN.getName()));
            return bundleBackendToken;
        }

        private static ServiceDescriptor findService(List<ServiceDescriptor> allServices, @NotNull String serviceId) {
            for (ServiceDescriptor descriptor : allServices) {
                if (!serviceId.equals(descriptor.getId())) continue;
                return descriptor;
            }
            return null;
        }
    }
}

