/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.api.internal.backend.impl.BundleFacadeDelegate;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledService;
import com.jetbrains.bundle.services.impl.CliService;
import com.jetbrains.service.util.logging.JavaUtilLoggingToSlf4jBridge;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundledCliService
extends BundledService {
    private final CliService myCliService;

    public BundledCliService(@NotNull ServiceDescriptor serviceDescriptor, String serviceStatusURL, @NotNull ServicesContainer hostingContainer, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, serviceStatusURL, hostingContainer, applicationContextHolder);
        this.myCliService = new CliService(serviceDescriptor, applicationContextHolder);
    }

    @Override
    public void configure(@NotNull Properties properties) {
        super.configure(properties);
        this.myCliService.configure(properties);
    }

    @Override
    protected void afterStart() {
        super.afterStart();
        JavaUtilLoggingToSlf4jBridge.install();
    }

    @Override
    @NotNull
    protected Map<String, Object> getAfterStartCallbackParameters() throws IOException {
        Map<String, Object> params = super.getAfterStartCallbackParameters();
        params.put("jetbrains.bundle.service", BundleFacadeDelegate.getBundleFacade());
        params.put("jetbrains.bundle.properties.service", BundleFacadeDelegate.getBundleFacade());
        return params;
    }

    @Override
    @Nullable
    ClassLoader getParentClassLoaderForAfterStartCallback() {
        return this.getWebAppClassloader();
    }

    @Override
    @NotNull
    public Map<String, String> listSystemProperties() {
        return this.myCliService.listSystemProperties();
    }

    @Override
    public File getServiceConfLocation() {
        return this.myCliService.getServiceConfLocation();
    }
}

