/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.properties.ServiceConfigurationHelper;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;

public abstract class BundledService
extends ServiceBase {
    private final String myServiceStatusURL;
    private final ServicesContainer myHostingContainer;
    private ClassLoader webAppClassloader;
    private SSLContext mySslContext;

    public BundledService(@NotNull ServiceDescriptor serviceDescriptor, String serviceStatusURL, @NotNull ServicesContainer hostingContainer, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, applicationContextHolder);
        this.myServiceStatusURL = serviceStatusURL;
        this.myHostingContainer = hostingContainer;
    }

    @Override
    public void doStart() throws StartupException {
        this.webAppClassloader = this.myHostingContainer.startServiceInContainer(this.getDescriptor().getId());
    }

    @NotNull
    final ClassLoader getWebAppClassloader() {
        if (this.webAppClassloader == null) {
            throw new IllegalStateException("Web App Classloader has not been initialized yet");
        }
        return this.webAppClassloader;
    }

    @Override
    public void stop(boolean force, @NotNull AppExitCode suggestedExitCode) {
        this.myHostingContainer.stopServiceInContainer(this.getDescriptor().getId());
    }

    @Override
    @NotNull
    public StatusDescriptor status() {
        return this.myServiceStatusURL != null ? this.getStatus(this.myServiceStatusURL) : new StatusDescriptor(Status.ERROR, "Service status URL is not defined");
    }

    @Override
    public void configure(@NotNull Properties properties) {
        super.configure(properties);
        if (UrlUtil.isSecuredUrl((String)this.myServiceStatusURL)) {
            try {
                this.mySslContext = KeystoreUtil.buildSSLContext((ServiceConfigurationHelper)PropertiesBasedConfigurationHelper.getHelper(), (Object)this.getProperties());
            }
            catch (Exception e) {
                this.LOG.debug("Cannot create SSL context: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NotNull
    private StatusDescriptor getStatus(String url) {
        HttpURLConnection connection = null;
        try {
            URL siteURL = new URL(url);
            connection = (HttpURLConnection)siteURL.openConnection();
            if (connection instanceof HttpsURLConnection && this.mySslContext != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.mySslContext.getSocketFactory());
            }
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            StatusDescriptor statusDescriptor = code == 200 ? new StatusDescriptor(Status.RUNNING, null) : new StatusDescriptor(Status.ERROR, "GET request to [" + url + "] returned HTTP code [" + code + "]");
            return statusDescriptor;
        }
        catch (IOException e) {
            throw new StatusException("Service status could not be identified", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public final File getServiceConfigFile() {
        return new File(this.getServiceConfLocation(), "service-config.properties");
    }
}

