/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.exceptions.BundleStartupException;
import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidationException;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.bundle.util.hub.HubServiceUpdater;
import com.jetbrains.bundle.util.hub.UpdaterHubServiceException;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.client.accounts.ServiceCredentialsValidationResult;
import jetbrains.jetpass.client.resource.ErrorHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HubConfiguratorService
extends ServiceBase {
    private static final String HUB_CONFIG_DIRECTORY_NAME = "conf";
    private static final String HUB_PARAMETERS_FILE_NAME = "hub-config.properties";
    private final BundleEnvironment bundleEnvironment;

    public HubConfiguratorService(@NotNull ServiceDescriptor serviceDescriptor, @NotNull BundleEnvironment bundleEnvironment, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, applicationContextHolder);
        this.bundleEnvironment = bundleEnvironment;
    }

    @Override
    public void stop(boolean force, @NotNull AppExitCode suggestedExitCode) {
        this.LOG.debug(String.format("* Service %s is virtual, nothing would be done on service stop", this.getDescriptor().getId()));
    }

    @Override
    protected void doStart() throws StartupException {
        Properties properties = this.getProperties();
        if (properties == null) {
            throw new IllegalStateException(String.format("Service %s is not configured", this.getDescriptor().getId()));
        }
        this.configureHubServices(properties);
    }

    private void configureHubServices(Properties properties) {
        BundleHubClient bundleHubClient = this.getBundleHubClient(properties);
        if (bundleHubClient == null) {
            this.LOG.warn("Bundle Hub client was not created, although it may be required for Hub services' update. Check you configuration!");
            return;
        }
        boolean connectionEstablished = this.checkIfThereIsConnectionToHub(bundleHubClient);
        if (!connectionEstablished) {
            if (PropertiesBasedConfigurationHelper.getHelper().isCleanInstallation((Object)properties) || PropertiesBasedConfigurationHelper.getHelper().isProductUpgrade((Object)properties)) {
                throw new BundleStartupException(String.format("Hub is unavailable %s", bundleHubClient.getHubUrl()));
            }
            return;
        }
        HubServiceUpdater hubServicesUpdater = this.createHubServicesUpdater(bundleHubClient);
        try {
            Properties expectedHubProperties = hubServicesUpdater.update();
            File hubConfigFile = this.getOldHubConfigFile();
            ConfiguratorUtils.savePropertiesFile((File)hubConfigFile, (Properties)expectedHubProperties);
        }
        catch (UpdaterHubServiceException e) {
            String baseMessage;
            switch (e.getCheckResult().getStatus()) {
                case EXISTS_WRONG_SECRET: {
                    if (e.isBundleServiceProblem()) {
                        baseMessage = "Could not register service(s) in Hub because bundle's service in Hub has wrong secret.\nCheck property bundle-hub-service-secret in file conf/internal/hub.properties.\n";
                        break;
                    }
                    baseMessage = String.format("Could not update service in Hub because it has wrong secret.\nCheck property %s.service.secret in file conf/internal/hub.properties.\n", e.getServiceInBundleId());
                    break;
                }
                case EXISTS_NOT_VERIFIED: {
                    if (e.isBundleServiceProblem()) {
                        baseMessage = "Could not register service(s) in Hub because bundle's service in Hub is not trusted.\n";
                        break;
                    }
                    baseMessage = String.format("Could not update service %s in Hub because it is not trusted.\n", e.getServiceInBundleId());
                    break;
                }
                case NOT_EXISTS: {
                    if (e.isBundleServiceProblem()) {
                        baseMessage = "Bundle's service does not exist in Hub. Check property bundle-hub-service-id in file conf/internal/hub.properties\n";
                        break;
                    }
                    baseMessage = String.format("Service does not exists in Hub. Check property %s.service.id in file conf/internal/hub.properties\n", e.getServiceInBundleId());
                    break;
                }
                default: {
                    baseMessage = "Error during creation or update of services in Hub.\n";
                }
            }
            this.LOG.error("{} Problem: {}", new Object[]{baseMessage, e.getMessage(), e});
            throw e;
        }
        catch (WebApplicationException e) {
            this.LOG.error("Cannot update Hub properties: {}. Details: {}", new Object[]{e.getMessage(), ErrorHelper.INSTANCE.readError(e).getDeveloperMessage(), e});
            throw e;
        }
        catch (Exception e) {
            this.LOG.error("Cannot update Hub properties: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfThereIsConnectionToHub(BundleHubClient bundleHubClient) {
        if (bundleHubClient.isInternalHub()) {
            return true;
        }
        boolean connected = false;
        int timeToWaitHubInMillis = Integer.getInteger("bundle.wait.external.hub.startup.in.seconds", 60) * 1000;
        long startTime = System.currentTimeMillis();
        while (!connected && System.currentTimeMillis() - startTime < (long)timeToWaitHubInMillis) {
            try {
                bundleHubClient.getHubClient();
                connected = true;
            }
            catch (HubUrlValidationException e) {
                ServiceCredentialsValidationResult.Status status = e.getStatus();
                if (status == ServiceCredentialsValidationResult.Status.CANT_CONNECT || status == ServiceCredentialsValidationResult.Status.UNKNOWN_HOST || status == ServiceCredentialsValidationResult.Status.TIMEOUT || e.getCause() instanceof NotFoundException || e.getCause() instanceof ServiceUnavailableException) {
                    this.LOG.debug(String.format("Failed to connect to external Hub %s", bundleHubClient.getHubUrl()), (Throwable)e);
                    HubConfiguratorService hubConfiguratorService = this;
                    synchronized (hubConfiguratorService) {
                        try {
                            this.wait(15000L);
                        }
                        catch (InterruptedException e1) {
                            break;
                        }
                    }
                }
                this.LOG.debug(String.format("Connection to external Hub %s was established, but Hub client creation failed", bundleHubClient.getHubUrl()), (Throwable)e);
                return true;
            }
        }
        return connected;
    }

    @NotNull
    private HubServiceUpdater createHubServicesUpdater(@NotNull BundleHubClient bundleHubClient) {
        Properties properties = this.getProperties();
        Properties oldHubProperties = this.initOldHubProperties();
        return new HubServiceUpdater(oldHubProperties, properties, bundleHubClient);
    }

    @Nullable
    private BundleHubClient getBundleHubClient(@NotNull Properties properties) {
        return BundleHubClient.getBundleHubClient((Properties)properties);
    }

    @Override
    public File getServiceConfigFile() {
        throw new UnsupportedOperationException(String.format("* Service %s is virtual and has no associated service properties file", this.getDescriptor().getId()));
    }

    @Override
    public File getServiceConfLocation() {
        return this.bundleEnvironment.getInternalServiceConfDir(this.getDescriptor().getId());
    }

    @Override
    @NotNull
    public StatusDescriptor status() {
        return new StatusDescriptor(Status.RUNNING, null);
    }

    @NotNull
    private Properties initOldHubProperties() {
        File file = this.getOldHubConfigFile();
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)file);
        }
        catch (Exception e) {
            this.LOG.debug("No properties file is found at: {}", (Object)file.getPath());
            return this.initOldHubPropertiesFromLegacyLocation();
        }
    }

    @NotNull
    private Properties initOldHubPropertiesFromLegacyLocation() {
        Properties oldHubConfigProperties = new Properties();
        String dataDir = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.getProperties(), "hub", ServiceProperties.DATA_DIR_PROPERTY);
        if (dataDir != null) {
            File file = Paths.get(dataDir, new String[0]).resolve(HUB_CONFIG_DIRECTORY_NAME).resolve(HUB_PARAMETERS_FILE_NAME).toFile();
            try {
                oldHubConfigProperties = ConfiguratorUtils.loadPropertiesFile((File)file);
            }
            catch (Exception ex) {
                this.LOG.debug("No legacy properties file is found at: {}", (Object)file.getPath());
            }
        } else {
            this.LOG.debug("No legacy properties file is found");
        }
        return oldHubConfigProperties;
    }

    private File getOldHubConfigFile() {
        Path configDirectory = this.getOrCreateConfigDirectory();
        return configDirectory.resolve(HUB_PARAMETERS_FILE_NAME).toFile();
    }

    @NotNull
    private Path getOrCreateConfigDirectory() {
        File configDir = this.getServiceConfLocation();
        if (!configDir.exists()) {
            configDir.mkdirs();
            if (!configDir.isDirectory()) {
                this.LOG.warn(String.format("Can not create directory [%s]", configDir.getAbsolutePath()));
            }
        }
        return configDir.toPath();
    }

    public static Path getConfigFileRelativePath(BundleEnvironment bundleEnvironment) {
        Path configFilePath = HubConfiguratorService.getConfigFileAbsolutePath(bundleEnvironment);
        Path confDirPath = bundleEnvironment.getConfDir().toAbsolutePath();
        return confDirPath.relativize(configFilePath);
    }

    public static Path getConfigFileAbsolutePath(BundleEnvironment bundleEnvironment) {
        return bundleEnvironment.getInternalServiceConfDir("bundle-hub-configurator").toPath().resolve(HUB_PARAMETERS_FILE_NAME).toAbsolutePath();
    }
}

