/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.Service;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.ClazzLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceBase
implements Service {
    private Properties myProperties;
    @NotNull
    private final ServiceDescriptor myServiceDescriptor;
    @NotNull
    private final ApplicationContextHolder myApplicationContextHolder;
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public ServiceBase(@NotNull ServiceDescriptor serviceDescriptor, @NotNull ApplicationContextHolder applicationContextHolder) {
        this.myServiceDescriptor = serviceDescriptor;
        this.myApplicationContextHolder = applicationContextHolder;
    }

    @Override
    public void configure(@NotNull Properties properties) {
        this.myProperties = properties;
    }

    protected Properties getProperties() {
        return this.myProperties;
    }

    public String getProperty(String propertyName) {
        return this.myProperties.getProperty(propertyName);
    }

    @Override
    @NotNull
    public ServiceDescriptor getDescriptor() {
        return this.myServiceDescriptor;
    }

    @Override
    public final void start() throws StartupException {
        this.doStart();
        this.afterStart();
    }

    protected abstract void doStart() throws StartupException;

    protected void afterStart() {
        String afterStartCallbackClass = this.getProperty("after-start-callback-class");
        if (afterStartCallbackClass != null && !afterStartCallbackClass.trim().isEmpty()) {
            try {
                this.executeAfterStartCallback(afterStartCallbackClass);
            }
            catch (NoSuchMethodException e) {
                this.LOG.error(String.format("after start callback class [%s] has no convenient instance method 'perform'", afterStartCallbackClass), (Throwable)e);
            }
        }
    }

    private void executeAfterStartCallback(String afterStartCallbackClass) throws NoSuchMethodException {
        try {
            Map<String, Object> parameters = this.getAfterStartCallbackParameters();
            ClassLoader parentClassLoaderForAfterStartCallback = this.getParentClassLoaderForAfterStartCallback();
            if (parentClassLoaderForAfterStartCallback != null) {
                parameters.put("skip.default.logging.initialization", Boolean.TRUE);
            }
            ClazzLoader.callMethod((File[])new File[]{this.getServiceHome().resolve("lib").toFile()}, (String)afterStartCallbackClass, (String)"perform", (Class[])new Class[]{Map.class}, (Object[])new Object[]{parameters}, (ClassLoader)parentClassLoaderForAfterStartCallback);
        }
        catch (IOException e) {
            this.LOG.warn("* Service {}: can not prepare after start callback call ", (Object)this.getDescriptor().getPresentableName(), (Object)e);
        }
    }

    @Nullable
    ClassLoader getParentClassLoaderForAfterStartCallback() {
        return null;
    }

    @NotNull
    protected Map<String, Object> getAfterStartCallbackParameters() throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jetbrains.service.config.path", this.getServiceConfLocation().getCanonicalPath());
        parameters.put("jetbrains.debug.enabled", String.valueOf(this.myApplicationContextHolder.isDebugEnabled()));
        return parameters;
    }

    protected Path getServiceHome() {
        return this.myServiceDescriptor.getFullPath();
    }

    public abstract File getServiceConfigFile();

    public abstract File getServiceConfLocation();

    @Override
    @NotNull
    public Map<String, String> listSystemProperties() {
        return Collections.emptyMap();
    }

    @NotNull
    protected final ApplicationContextHolder getApplicationContextHolder() {
        return this.myApplicationContextHolder;
    }
}

