/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.hub;

import com.jetbrains.bundle.util.hub.ServiceParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import jersey.repackaged.com.google.common.collect.Sets;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;

public class ServiceParameters {
    public static final ServiceParameter<String> homeUrl = new StringParameter("homeUrl"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setHomeUrl(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getHomeUrl();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.HOME_URL;
        }
    };
    public static final ServiceParameter<Iterable<String>> redirectUris = new ListOfStringsParameter("redirectUris"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setRedirectUris((Iterable)this.restore(value));
        }

        @Override
        public boolean areEqualRawValues(String o1, String o2) {
            throw new UnsupportedOperationException("This method is not supposed to be called");
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return this.toRawValue(serviceJSON.getRedirectUris());
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.REDIRECT_URIS;
        }
    };
    public static final ServiceParameter<String> name = new StringParameter("name"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setName(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getName();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.NAME;
        }
    };
    public static final ServiceParameter<String> id = new StringParameter("id"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setId(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getId();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.ID;
        }
    };
    public static final ServiceParameter<String> applicationName = new StringParameter("applicationName"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setApplicationName(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getApplicationName();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.APPLICATION_NAME;
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return true;
        }
    };
    public static final ServiceParameter<String> applicationVersion = new StringParameter("version"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setVersion(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getVersion();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.VERSION;
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return true;
        }
    };
    public static final ServiceParameter<String> applicationVendor = new StringParameter("vendor"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            serviceJSON.setVendor(value);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            return serviceJSON.getVendor();
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.VENDOR;
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return true;
        }
    };
    public static ServiceParameter<String> licenseKey = new StringParameter("licenseKey"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            LicenseJSON licenseSettings = serviceJSON.getLicenseSettings();
            if (licenseSettings == null) {
                licenseSettings = new LicenseJSON();
            }
            licenseSettings.setLicenseKey(value);
            serviceJSON.setLicenseSettings(licenseSettings);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            LicenseJSON licenseSettings = serviceJSON.getLicenseSettings();
            if (licenseSettings == null) {
                return null;
            }
            return licenseSettings.getLicenseKey();
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return true;
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.LICENSE_SETTINGS((Partial.License[])new Partial.License[]{Partial.License.LICENSE_KEY});
        }
    };
    public static ServiceParameter<String> licenseUserName = new StringParameter("licenseUserName"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            LicenseJSON licenseSettings = serviceJSON.getLicenseSettings();
            if (licenseSettings == null) {
                licenseSettings = new LicenseJSON();
            }
            licenseSettings.setLicenseName(value);
            serviceJSON.setLicenseSettings(licenseSettings);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            LicenseJSON licenseSettings = serviceJSON.getLicenseSettings();
            if (licenseSettings == null) {
                return null;
            }
            return licenseSettings.getLicenseName();
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return true;
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.LICENSE_SETTINGS((Partial.License[])new Partial.License[]{Partial.License.LICENSE_NAME});
        }
    };
    public static ListOfStringsParameter headerVisibleGroupIds = new ListOfStringsParameter("headerVisibleGroupIds"){

        @Override
        public void setValueToServiceJson(ServiceJSON serviceJSON, String value) {
            Object ids = this.restore(value);
            ArrayList<UserGroupJSON> groups = new ArrayList<UserGroupJSON>();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                UserGroupJSON group = new UserGroupJSON();
                group.setId(id);
                groups.add(group);
            }
            serviceJSON.setHeaderVisibleGroups(groups);
        }

        @Override
        public boolean areEqualRawValues(String o1, String o2) {
            Object idsIt1 = this.restore(o1);
            HashSet ids1 = idsIt1 != null ? Sets.newHashSet((Iterable)idsIt1) : new HashSet();
            Object idsIt2 = this.restore(o2);
            HashSet ids2 = idsIt2 != null ? Sets.newHashSet((Iterable)idsIt2) : new HashSet();
            return ids1.equals(ids2);
        }

        @Override
        public String getValueFromServiceJson(ServiceJSON serviceJSON) {
            Iterable headerVisibleGroups = serviceJSON.getHeaderVisibleGroups();
            HashSet<String> ids = new HashSet<String>();
            if (headerVisibleGroups != null) {
                for (UserGroupJSON group : headerVisibleGroups) {
                    String id = group.getId();
                    if (id == null) continue;
                    ids.add(id);
                }
            }
            return this.toRawValue((Iterable<String>)ids);
        }

        @Override
        public Partial.Service getPartial() {
            return Partial.Service.HEADER_VISIBLE_GROUPS((Partial.UserGroup[])new Partial.UserGroup[]{Partial.UserGroup.ID});
        }
    };

    public static abstract class ListOfStringsParameter
    extends BaseParameter<Iterable<String>> {
        private static final String LIST_ENTRIES_DELIMITER = "|||";

        public ListOfStringsParameter(@NotNull String name) {
            super(name);
        }

        @Override
        public String toRawValue(Iterable<String> paramValue) {
            if (paramValue == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String value : paramValue) {
                sb.append(value).append(LIST_ENTRIES_DELIMITER);
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - LIST_ENTRIES_DELIMITER.length(), sb.length());
                return sb.toString();
            }
            return null;
        }

        @Override
        public Iterable<String> restore(String rawValue) {
            if (rawValue == null) {
                return null;
            }
            String[] parties = rawValue.split(Pattern.quote(LIST_ENTRIES_DELIMITER));
            return Arrays.asList(parties);
        }
    }

    public static abstract class StringParameter
    extends BaseParameter<String> {
        public StringParameter(@NotNull String name) {
            super(name);
        }

        @Override
        public String toRawValue(String paramValue) {
            return paramValue;
        }

        @Override
        public String restore(String rawValue) {
            return rawValue;
        }

        @Override
        public boolean areEqualRawValues(String o1, String o2) {
            return Objects.equals(o1, o2);
        }
    }

    public static abstract class BaseParameter<T>
    implements ServiceParameter<T> {
        private final String name;

        public BaseParameter(@NotNull String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean alwaysOverwriteHubValue() {
            return false;
        }
    }
}

