/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import com.jetbrains.service.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.servicecomb.foundation.common.utils.FilePerm;

abstract class FileModeMapper {
    private static final Logger LOG = Logger.getLogger(FileModeMapper.class.getCanonicalName());
    private ArchiveEntry archiveEntry;

    FileModeMapper(ArchiveEntry archiveEntry) {
        this.archiveEntry = archiveEntry;
    }

    public abstract void map(File var1) throws IOException;

    ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    public static void map(ArchiveEntry entry, File file) throws IOException {
        FileModeMapper.create(entry).map(file);
    }

    public static FileModeMapper create(ArchiveEntry entry) {
        if (SystemUtil.isWindows()) {
            return new FallbackFileModeMapper(entry);
        }
        return new UnixPermissionMapper(entry);
    }

    static abstract class AttributeAccessor<E extends ArchiveEntry> {
        private E entry;

        AttributeAccessor(E entry) {
            this.entry = entry;
        }

        public E getEntry() {
            return this.entry;
        }

        public abstract int getMode() throws IOException;

        public static AttributeAccessor<?> create(ArchiveEntry entry) {
            if (entry instanceof TarArchiveEntry) {
                return new TarAttributeAccessor((TarArchiveEntry)entry);
            }
            if (entry instanceof ZipArchiveEntry) {
                return new ZipAttributeAccessor((ZipArchiveEntry)entry);
            }
            if (entry instanceof CpioArchiveEntry) {
                return new CpioAttributeAccessor((CpioArchiveEntry)entry);
            }
            if (entry instanceof ArjArchiveEntry) {
                return new ArjAttributeAccessor((ArjArchiveEntry)entry);
            }
            if (entry instanceof ArArchiveEntry) {
                return new ArAttributeAccessor((ArArchiveEntry)entry);
            }
            return new FallbackAttributeAccessor(entry);
        }

        public static class ArAttributeAccessor
        extends AttributeAccessor<ArArchiveEntry> {
            ArAttributeAccessor(ArArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() throws IOException {
                return ((ArArchiveEntry)this.getEntry()).getMode();
            }
        }

        public static class ArjAttributeAccessor
        extends AttributeAccessor<ArjArchiveEntry> {
            ArjAttributeAccessor(ArjArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() throws IOException {
                return ((ArjArchiveEntry)this.getEntry()).getMode();
            }
        }

        public static class CpioAttributeAccessor
        extends AttributeAccessor<CpioArchiveEntry> {
            CpioAttributeAccessor(CpioArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() {
                return (int)((CpioArchiveEntry)this.getEntry()).getMode();
            }
        }

        public static class ZipAttributeAccessor
        extends AttributeAccessor<ZipArchiveEntry> {
            ZipAttributeAccessor(ZipArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() {
                return ((ZipArchiveEntry)this.getEntry()).getUnixMode();
            }
        }

        public static class TarAttributeAccessor
        extends AttributeAccessor<TarArchiveEntry> {
            TarAttributeAccessor(TarArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() {
                return ((TarArchiveEntry)this.getEntry()).getMode();
            }
        }

        public static class FallbackAttributeAccessor
        extends AttributeAccessor<ArchiveEntry> {
            FallbackAttributeAccessor(ArchiveEntry entry) {
                super(entry);
            }

            @Override
            public int getMode() {
                return 0;
            }
        }
    }

    public static class UnixPermissionMapper
    extends FileModeMapper {
        static final int UNIX_PERMISSION_MASK = 511;

        UnixPermissionMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file) throws IOException {
            int perm = this.getMode() & 0x1FF;
            if (perm > 0 && !SystemUtil.isWindows()) {
                this.chmod(perm, file);
            }
        }

        public int getMode() throws IOException {
            return AttributeAccessor.create(this.getArchiveEntry()).getMode();
        }

        private void chmod(int mode, File file) throws IOException {
            try {
                Files.setPosixFilePermissions(file.toPath(), FilePerm.getPosixPerm((int)mode));
            }
            catch (Exception e) {
                LOG.warning("Could not set file permissions of " + file + ". Exception was: " + e.getMessage());
            }
        }
    }

    public static class FallbackFileModeMapper
    extends FileModeMapper {
        FallbackFileModeMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file) throws IOException {
        }
    }
}

