/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.auth.impl;

import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.auth.AuthService;
import com.jetbrains.bundle.util.auth.Authenticator;
import com.jetbrains.bundle.util.auth.exceptions.AuthenticationException;
import com.jetbrains.bundle.util.auth.exceptions.TooManyFailedAuthAttemptsException;
import org.jetbrains.annotations.NotNull;

public class SimpleAuthenticator
implements Authenticator {
    @NotNull
    private final AuthService authService;

    public SimpleAuthenticator(@NotNull AuthService authService) {
        this.authService = authService;
    }

    @Override
    public void authenticate(String awcToken) throws AuthenticationException, TooManyFailedAuthAttemptsException {
        AuthResult authResult = this.authService.authenticate(awcToken != null ? awcToken.trim() : "");
        if (!authResult.isSuccessful()) {
            throw new AuthenticationException(authResult.getTokenStorage());
        }
    }

    @NotNull
    AuthService getAuthService() {
        return this.authService;
    }
}

